/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.impl.NewUserListener;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.CalendarUtils;
import org.exoplatform.mail.webui.popup.UIAddressForm;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAddressForm.gtmpl", events={@EventConfig(listeners={ChangeGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchContactActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ReplaceActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressForm
extends UIForm
implements UIPopupComponent {
    public static final String CONTACT_SEARCH = "contact-search".intern();
    public static final String CONTACT_GROUP = "contact-group".intern();
    public LinkedHashMap<String, Contact> checkedList_ = new LinkedHashMap();
    public LinkedHashMap<String, Contact> newCheckedList_ = new LinkedHashMap();
    private String avaiAddressStr = "";
    private String selectedAddressId_ = "";
    private String recipientsType_ = "";
    private UIPageIterator uiPageList_;
    private String all = "all";
    private String sharedContacts_ = "sharedContacts";

    public void setRecipientsType(String type) {
        this.recipientsType_ = type;
    }

    public String getRecipientType() {
        return this.recipientsType_;
    }

    public void setAvaiAddressStr(String str) {
        this.avaiAddressStr = str;
    }

    public String getAvaiAddressStr() {
        return this.avaiAddressStr;
    }

    public UIAddressForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONTACT_SEARCH, CONTACT_SEARCH, null));
        UIFormSelectBoxWithGroups uiSelect = new UIFormSelectBoxWithGroups(CONTACT_GROUP, CONTACT_GROUP, this.getOptions());
        uiSelect.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)uiSelect);
        uiSelect.setValue(NewUserListener.DEFAULTGROUP + MailUtils.getCurrentUser());
        this.uiPageList_ = new UIPageIterator();
        this.uiPageList_.setId("UIMailAddressPage");
        this.setContactList(NewUserListener.DEFAULTGROUP + MailUtils.getCurrentUser());
    }

    public List<SelectItem> getOptions() throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        options.add((SelectItem)new SelectOption(this.all, this.all));
        List contactGroup = contactSrv.getGroups(username);
        if (!contactGroup.isEmpty()) {
            SelectOptionGroup personalContacts = new SelectOptionGroup("personal-contacts");
            for (AddressBook pcg : contactGroup) {
                personalContacts.addOption(new SelectOption(pcg.getName(), pcg.getId()));
            }
            options.add((SelectItem)personalContacts);
        }
        DataPageList sharedContacts = contactSrv.getSharedContacts(username);
        List sharedAdds = contactSrv.getSharedAddressBooks(username);
        if (!sharedAdds.isEmpty() || sharedContacts.getAll().size() > 0) {
            SelectOptionGroup sharedAddress = new SelectOptionGroup("shared");
            for (SharedAddressBook scg : sharedAdds) {
                String name = "";
                if (!CalendarUtils.isEmpty((String)scg.getSharedUserId())) {
                    name = scg.getSharedUserId() + "-";
                }
                sharedAddress.addOption(new SelectOption(name + scg.getName(), scg.getId()));
            }
            sharedAddress.addOption(new SelectOption(this.sharedContacts_, this.sharedContacts_));
            options.add((SelectItem)sharedAddress);
        }
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        Object[] objGroupIds = organizationService.getGroupHandler().findGroupsOfUser(username).toArray();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Object object : objGroupIds) {
            groupIds.add(((GroupImpl)object).getId());
        }
        if (!groupIds.isEmpty()) {
            SelectOptionGroup publicContacts = new SelectOptionGroup("public-contacts");
            for (String publicCg : groupIds) {
                publicContacts.addOption(new SelectOption(publicCg, publicCg));
            }
            options.add((SelectItem)publicContacts);
        }
        return options;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<Contact> getContacts() throws Exception {
        UIFormCheckBoxInput uiInput;
        ArrayList<Contact> contacts = new ArrayList<Contact>(this.uiPageList_.getCurrentPageData());
        for (Contact c : contacts) {
            uiInput = this.getUIFormCheckBoxInput(c.getId());
            if (uiInput != null) continue;
            uiInput = new UIFormCheckBoxInput(c.getId(), c.getId(), null);
            this.addUIFormInput((UIFormInput)uiInput);
        }
        for (Contact c : this.checkedList_.values()) {
            uiInput = this.getUIFormCheckBoxInput(c.getId());
            if (uiInput == null) continue;
            uiInput.setChecked(true);
        }
        return contacts;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageList_;
    }

    public long getAvailablePage() {
        return this.uiPageList_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageList_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageList_.setCurrentPage(page);
    }

    public void setContactList(String groupId) throws Exception {
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ContactFilter filter = new ContactFilter();
        if (!MailUtils.isFieldEmpty((String)groupId)) {
            filter.setCategories(new String[]{groupId});
        }
        DataPageList resultPageList = contactSrv.searchContact(MailUtils.getCurrentUser(), filter);
        this.setContactList(resultPageList.getAll());
    }

    public void setContactList(List<Contact> contactList) throws Exception {
        ObjectPageList objPageList = new ObjectPageList(contactList, 10);
        this.uiPageList_.setPageList((PageList)objPageList);
    }

    public void setAlreadyCheckedContact(List<Contact> alreadyCheckedContact) throws Exception {
        for (Contact ct : alreadyCheckedContact) {
            this.checkedList_.put(ct.getId(), ct);
        }
    }

    public List<Contact> getCheckedContact() throws Exception {
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        for (Contact contact : new ArrayList(this.uiPageList_.getCurrentPageData())) {
            UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            contactList.add(contact);
        }
        return contactList;
    }

    static /* synthetic */ String access$000(UIAddressForm x0) {
        return x0.all;
    }

    static /* synthetic */ String access$100(UIAddressForm x0) {
        return x0.sharedContacts_;
    }

    static /* synthetic */ String access$202(UIAddressForm x0, String x1) {
        x0.selectedAddressId_ = x1;
        return x0.selectedAddressId_;
    }

    static /* synthetic */ String access$200(UIAddressForm x0) {
        return x0.selectedAddressId_;
    }
}

