/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.List;
import org.exoplatform.mail.Colors;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.mail.webui.popup.UIEditTagForm;
import org.exoplatform.mail.webui.popup.UIFormColorPicker;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIEditTagForm
extends UIForm
implements UIPopupComponent {
    public static final String NEW_TAG_NAME = "newTagName";
    public static final String DESCRIPTION = "description";
    public static final String COLOR = "color";
    private String tagId;

    public UIEditTagForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_TAG_NAME, NEW_TAG_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormColorPicker(COLOR, COLOR, Colors.COLORS));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
    }

    public String getSelectedColor() {
        return (String)((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).getValue();
    }

    public void setSelectedColor(String value) {
        ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setValue(value);
    }

    public String getTagId() throws Exception {
        return this.tagId;
    }

    public void setTag(String tagId) throws Exception {
        String accountId;
        String username;
        this.tagId = tagId;
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        List tagList = mailSrv.getTags(username = MailUtils.getCurrentUser(), accountId = ((UISelectAccount)((UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class)).findFirstComponentOfType(UISelectAccount.class)).getSelectedValue());
        if (tagList.isEmpty()) {
            return;
        }
        for (Tag tag : tagList) {
            if (!tag.getId().equals(tagId)) continue;
            this.getUIStringInput(NEW_TAG_NAME).setValue((Object)tag.getName());
            this.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)tag.getDescription());
            ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setValue(tag.getColor());
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

