/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.mail.webui.popup.UIAddressSearchForm;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/UIAddressForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressSearchForm
extends UIForm
implements UIPopupComponent {
    private String type = "";
    private Map<String, Contact> contactMap_ = new HashMap();

    public UIAddressSearchForm() throws Exception {
        this.setContactList();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<Contact> getContacts() throws Exception {
        return new ArrayList<Contact>(this.contactMap_.values());
    }

    public void setContactList() throws Exception {
        this.setContactList("");
    }

    public void setContactList(String groupId) throws Exception {
        List contacts = new ArrayList();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        contacts = groupId == null || groupId == "" ? contactSrv.getPersonalContacts(username) : contactSrv.getPersonalContactsByAddressBook(username, groupId).getAll();
        this.setContactList(contacts);
    }

    public void setContactList(List<Contact> contactList) throws Exception {
        this.getChildren().clear();
        this.contactMap_.clear();
        for (Contact contact : contactList) {
            UIFormCheckBoxInput uiCheckbox = new UIFormCheckBoxInput(contact.getId(), contact.getId(), (Object)false);
            this.addUIFormInput((UIFormInput)uiCheckbox);
            this.contactMap_.put(contact.getId(), contact);
        }
    }

    public List<Contact> getCheckedContact() throws Exception {
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        for (Contact contact : this.getContacts()) {
            UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            contactList.add(contact);
        }
        return contactList;
    }
}

