/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.mail.internet.InternetAddress;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.CalendarUtils;
import org.exoplatform.mail.webui.UIFolderContainer;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UIMessagePreview;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/mail/webui/UIMessagePreview.gtmpl", events={@EventConfig(listeners={DownloadAttachmentActionListener.class}), @EventConfig(listeners={AddStarActionListener.class}), @EventConfig(listeners={ReplyActionListener.class}), @EventConfig(listeners={ReplyAllActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIMessagePreview.msg.confirm-remove-message"), @EventConfig(listeners={ForwardActionListener.class}), @EventConfig(listeners={CreateFilterActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={AddTagActionListener.class}), @EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={MoveMessagesActionListener.class}), @EventConfig(listeners={AnswerInvitationActionListener.class}), @EventConfig(listeners={ViewAllHeadersActionListener.class}), @EventConfig(listeners={BackToListActionListener.class}), @EventConfig(listeners={SaveAttachmentToDMSActionListener.class}), @EventConfig(listeners={HideMessageListActionListener.class})})
public class UIMessagePreview
extends UIContainer
implements UISelectable {
    public static String QUESTION = "question".intern();
    public static String ANSWER_IMPORT = "yes-import".intern();
    public static String ANSWER_YES = "yes".intern();
    public static String ANSWER_NO = "no".intern();
    public static String ANSWER_MAYBE = "maybe".intern();
    private Message selectedMessage_;
    private List<Message> showedMsgs = new ArrayList();
    private boolean isHideMessageList_ = false;
    private List<String> unreadMsgIds = new ArrayList();
    private Attachment selectedAttachment_;

    public Message getMessage() throws Exception {
        return this.selectedMessage_;
    }

    public void setMessage(Message msg) throws Exception {
        this.selectedMessage_ = msg;
    }

    public List<Message> getShowedMessages() throws Exception {
        return this.showedMsgs;
    }

    public void setShowedMessages(List<Message> msgList) throws Exception {
        this.showedMsgs = msgList;
    }

    public List<String> getUnreadMessages() throws Exception {
        return this.unreadMsgIds;
    }

    public void setUnreadMessages(List<String> unreadMsgIds) throws Exception {
        this.unreadMsgIds = unreadMsgIds;
    }

    public Attachment getSelectedAttachment_() {
        return this.selectedAttachment_;
    }

    public void setSelectedAttachment_(Attachment selectedAttachment) {
        this.selectedAttachment_ = selectedAttachment;
    }

    public Map<String, String> getImageLocationMap(Message message) throws Exception {
        HashMap<String, String> imageLocation = new HashMap<String, String>();
        DownloadService dservice = this.getDownloadService();
        String attLink = "";
        String attId = "";
        if (message.getAttachments() != null) {
            for (Attachment att : message.getAttachments()) {
                if (!att.isShownInBody() || (attLink = MailUtils.getImageSource((Attachment)att, (DownloadService)dservice)) == null) continue;
                attLink = MailUtils.getAttachmentLink((Attachment)att);
                attId = att.getId();
                imageLocation.put(attId.substring(attId.lastIndexOf("/") + 1, attId.length()), attLink.substring(0, attLink.lastIndexOf("/") + 1));
            }
        }
        return imageLocation;
    }

    public void setIsHideMessageList(boolean b) {
        this.isHideMessageList_ = b;
    }

    public boolean isHideMessageList() {
        return this.isHideMessageList_;
    }

    public boolean isShowBcc(Message msg) throws Exception {
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String selectedFolder = ((UIFolderContainer)uiPortlet.findFirstComponentOfType(UIFolderContainer.class)).getSelectedFolder();
        String accId = ((UISelectAccount)uiPortlet.findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
        String username = MailUtils.getCurrentUser();
        MailService mailServ = (MailService)uiPortlet.getApplicationComponent(MailService.class);
        Account account = mailServ.getAccountById(username, accId);
        InternetAddress[] fromAddress = Utils.getInternetAddress((String)msg.getFrom());
        InternetAddress from = fromAddress[0];
        return !MailUtils.isFieldEmpty((String)selectedFolder) && selectedFolder.equals(Utils.generateFID((String)accId, (String)Utils.FD_SENT, (boolean)false)) && !MailUtils.isFieldEmpty((String)msg.getMessageBcc()) && account != null && from.getAddress().equalsIgnoreCase(account.getEmailAddress());
    }

    public CalendarEvent getEvent(Message msg) throws Exception {
        CalendarService calendarSrv = (CalendarService)this.getApplicationComponent(CalendarService.class);
        CalendarEvent calEvent2 = null;
        try {
            if (0 == Integer.parseInt(MailUtils.getEventType((Message)msg))) {
                ArrayList<String> calIds = new ArrayList<String>();
                calIds.add(MailUtils.getCalendarId((Message)msg));
                for (CalendarEvent calEvent2 : calendarSrv.getUserEventByCalendar(MailUtils.getEventFrom((Message)msg), calIds)) {
                    if (!MailUtils.getCalendarEventId((Message)msg).equals(calEvent2.getId())) continue;
                }
                if (!MailUtils.getCalendarEventId((Message)msg).equals(calEvent2.getId())) {
                    calEvent2 = null;
                }
            } else if (1 != Integer.parseInt(MailUtils.getEventType((Message)msg)) && 2 == Integer.parseInt(MailUtils.getEventType((Message)msg))) {
                calEvent2 = calendarSrv.getGroupEvent(MailUtils.getCalendarId((Message)msg), MailUtils.getCalendarEventId((Message)msg));
            }
        }
        catch (Exception e) {
            calEvent2 = null;
        }
        return calEvent2;
    }

    public Message getShowedMessageById(String id) throws Exception {
        for (Message msg : this.getShowedMessages()) {
            if (!msg.getId().equals(id)) continue;
            return msg;
        }
        return null;
    }

    public DownloadService getDownloadService() {
        return (DownloadService)this.getApplicationComponent(DownloadService.class);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getAnswerStatus() throws Exception {
        CalendarEvent calEvent = this.getEvent(this.getMessage());
        if (calEvent == null) {
            return null;
        }
        String[] parStatus = calEvent.getParticipantStatus();
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String username = uiPortlet.getCurrentUser();
        String accId = ((UISelectAccount)uiPortlet.findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
        MailService mailSvr = (MailService)uiPortlet.getApplicationComponent(MailService.class);
        Account account = mailSvr.getAccountById(username, accId);
        String currentEmail = "";
        if (account != null) {
            currentEmail = account.getEmailAddress();
        }
        for (String par : parStatus) {
            String[] entry = par.split(":");
            if (!entry[0].equalsIgnoreCase(username) && !entry[0].equalsIgnoreCase(currentEmail)) continue;
            if (entry.length > 1) {
                return entry[1];
            }
            return new String("");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelect(String selectField, Object value) throws Exception {
        String valueString = value.toString();
        String relPath = valueString.substring(valueString.indexOf(":/") + 2);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        ApplicationMessage message = null;
        if (this.selectedAttachment_ != null) {
            MailService mailService = (MailService)this.getApplicationComponent(MailService.class);
            CmsService cmsService = (CmsService)this.getApplicationComponent(CmsService.class);
            Node folderNode = mailService.getDMSSelectedNode(CalendarUtils.getCurrentUser(), relPath);
            try {
                if (folderNode == null || folderNode.isNodeType(Utils.NT_FILE)) {
                    message = new ApplicationMessage("UIMessagePreview.msg.DMSSelector.notFolder", null, 1);
                } else {
                    try {
                        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
                        Map inputProps = this.getInputProperties(this.selectedAttachment_.getName(), this.selectedAttachment_.getInputStream(), this.selectedAttachment_.getMimeType());
                        cmsService.storeNodeByUUID(Utils.NT_FILE, folderNode, inputProps, true, repoService.getCurrentRepository().getConfiguration().getName());
                        message = new ApplicationMessage("UIMessagePreview.msg.DMSSelector.save-successfully", new Object[]{this.selectedAttachment_.getName().replace(".", "&#46;"), folderNode.getName()}, 2);
                    }
                    catch (Exception e) {
                        message = new ApplicationMessage("UIMessagePreview.msg.DMSSelector.save-error", null, 0);
                        e.printStackTrace();
                    }
                }
            }
            finally {
                folderNode.getSession().logout();
            }
            uiApp.addMessage(message);
            context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
        }
    }

    private Map<String, JcrInputProperty> getInputProperties(String name, InputStream inputStream, String mimeType) {
        HashMap<String, JcrInputProperty> inputProperties = new HashMap<String, JcrInputProperty>();
        JcrInputProperty nodeInput = new JcrInputProperty();
        nodeInput.setJcrPath("/node");
        nodeInput.setValue((Object)name);
        nodeInput.setMixintype("mix:i18n,mix:votable,mix:commentable");
        nodeInput.setType(1);
        inputProperties.put("/node", nodeInput);
        JcrInputProperty jcrContent = new JcrInputProperty();
        jcrContent.setJcrPath("/node/jcr:content");
        jcrContent.setValue((Object)"");
        jcrContent.setMixintype("dc:elementSet");
        jcrContent.setNodetype(Utils.NT_RESOURCE);
        jcrContent.setType(1);
        inputProperties.put("/node/jcr:content", jcrContent);
        JcrInputProperty jcrData = new JcrInputProperty();
        jcrData.setJcrPath("/node/jcr:content/jcr:data");
        jcrData.setValue((Object)inputStream);
        inputProperties.put("/node/jcr:content/jcr:data", jcrData);
        JcrInputProperty jcrMimeType = new JcrInputProperty();
        jcrMimeType.setJcrPath("/node/jcr:content/jcr:mimeType");
        jcrMimeType.setValue((Object)mimeType);
        inputProperties.put("/node/jcr:content/jcr:mimeType", jcrMimeType);
        JcrInputProperty jcrLastModified = new JcrInputProperty();
        jcrLastModified.setJcrPath("/node/jcr:content/jcr:lastModified");
        jcrLastModified.setValue((Object)new GregorianCalendar());
        inputProperties.put("/node/jcr:content/jcr:lastModified", jcrLastModified);
        JcrInputProperty jcrEncoding = new JcrInputProperty();
        jcrEncoding.setJcrPath("/node/jcr:content/jcr:encoding");
        jcrEncoding.setValue((Object)"UTF-8");
        inputProperties.put("/node/jcr:content/jcr:encoding", jcrEncoding);
        return inputProperties;
    }

    public boolean isShowPicInBody(Message msg) {
        List atts = msg.getAttachments();
        if (atts != null && atts.size() > 0) {
            for (Attachment attach : atts) {
                if (attach.isShownInBody()) continue;
                return false;
            }
        }
        return true;
    }
}

