/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UIMessageArea;
import org.exoplatform.mail.webui.UIMessageList;
import org.exoplatform.mail.webui.UIMessageListLifecycle;
import org.exoplatform.mail.webui.UIMessagePreview;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIMessageListLifecycle.class, template="app:/templates/mail/webui/UIMessageList.gtmpl", events={@EventConfig(listeners={SelectMessageActionListener.class}), @EventConfig(listeners={ReadActionListener.class}), @EventConfig(listeners={AddAccountActionListener.class}), @EventConfig(listeners={EditDraftActionListener.class}), @EventConfig(listeners={AddStarActionListener.class}), @EventConfig(listeners={RemoveStarActionListener.class}), @EventConfig(listeners={ReplyActionListener.class}), @EventConfig(listeners={ReplyAllActionListener.class}), @EventConfig(listeners={ForwardActionListener.class}), @EventConfig(listeners={CreateFilterActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIMessageList.msg.confirm-remove-message"), @EventConfig(listeners={ReportSpamActionListener.class}), @EventConfig(listeners={NotSpamActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={MarkAsReadActionListener.class}), @EventConfig(listeners={MarkAsUnReadActionListener.class}), @EventConfig(listeners={ViewAllActionListener.class}), @EventConfig(listeners={ViewAsListActionListener.class}), @EventConfig(listeners={ViewAsThreadActionListener.class}), @EventConfig(listeners={ViewAsConversationActionListener.class}), @EventConfig(listeners={GroupByDateActionListener.class}), @EventConfig(listeners={ViewStarredActionListener.class}), @EventConfig(listeners={ViewUnreadActionListener.class}), @EventConfig(listeners={ViewAttachmentActionListener.class}), @EventConfig(listeners={FirstPageActionListener.class}), @EventConfig(listeners={PreviousPageActionListener.class}), @EventConfig(listeners={NextPageActionListener.class}), @EventConfig(listeners={LastPageActionListener.class}), @EventConfig(listeners={AddTagActionListener.class}), @EventConfig(listeners={AddTagDnDActionListener.class}), @EventConfig(listeners={MoveMessagesActionListener.class}), @EventConfig(listeners={MoveDirectMessagesActionListener.class}), @EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={SortActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={ComfirmPasswordActionListener.class}), @EventConfig(listeners={UpdateListActionListener.class})})
public class UIMessageList
extends UIForm {
    private static final Log log = ExoLogger.getLogger(UIMessageList.class);
    public static final int MODE_LIST = 1;
    public static final int MODE_THREAD = 2;
    public static final int MODE_CONVERSATION = 3;
    public static final int MODE_GROUP_BY_DATE = 4;
    public static final int VIEW_ALL = 1;
    public static final int VIEW_STARRED = 2;
    public static final int VIEW_UNSTARRED = 3;
    public static final int VIEW_UNREAD = 4;
    public static final int VIEW_READ = 5;
    public static final int VIEW_ATTACHMENT = 6;
    private String selectedMessageId_ = null;
    private String selectedFolderId_ = null;
    private String selectedTagId_ = null;
    private String viewQuery_ = null;
    private String sortedBy_ = null;
    private boolean isAscending_ = false;
    private MessagePageList pageList_ = null;
    private MessageFilter msgFilter_;
    private String accountId_;
    public int viewMode = 2;
    public int viewing_ = 1;
    public LinkedHashMap<String, Message> messageList_ = new LinkedHashMap();

    public void init(String accountId) throws Exception {
        String selectedFolderId = Utils.generateFID((String)accountId, (String)Utils.FD_INBOX, (boolean)false);
        this.updateMessagePageList(accountId, selectedFolderId);
        this.setFormId();
    }

    public void updateMessagePageList(String accountId, String selectedFolderId) throws Exception {
        this.accountId_ = accountId;
        this.sortedBy_ = Utils.EXO_RECEIVEDDATE;
        String username = MailUtils.getCurrentUser();
        MailService mailSrv = MailUtils.getMailService();
        MessageFilter filter = this.getMessageFilter();
        if (filter == null) {
            filter = new MessageFilter("Folder");
        }
        if (this.viewMode == 2 || this.viewMode == 3) {
            filter.setOrderBy(Utils.EXO_LAST_UPDATE_TIME);
            filter.setHasStructure(true);
        }
        if (!Utils.isEmptyField((String)accountId)) {
            filter.setAccountId(accountId);
            if (filter.getFolder() == null) {
                if (!filter.getName().equals("Search")) {
                    this.selectedFolderId_ = selectedFolderId;
                    filter.setFolder(new String[]{this.selectedFolderId_});
                }
            } else {
                this.selectedFolderId_ = filter.getFolder()[0];
            }
            long currentPage = 1L;
            if (this.pageList_ != null) {
                currentPage = this.pageList_.getCurrentPage();
            }
            MessagePageList currentPageList = mailSrv.getMessagePageList(username, filter);
            this.setMessagePageList(currentPageList, currentPage);
        } else {
            this.messageList_.clear();
        }
        this.setMessageFilter(filter);
    }

    public void setFormId() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String formId = ((PortletRequestContext)context).getWindowId();
        UIMailPortlet mailportlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        UIMessageArea uiMsgArea = (UIMessageArea)this.getAncestorOfType(UIMessageArea.class);
        if (mailportlet == null && uiMsgArea != null) {
            mailportlet = (UIMailPortlet)uiMsgArea.getAncestorOfType(UIMailPortlet.class);
        }
        if (mailportlet != null) {
            mailportlet.setFormId(formId);
        }
    }

    public boolean isMessagePreviewRendered() {
        try {
            return ((UIMessagePreview)((UIMessageArea)this.getAncestorOfType(UIMessageArea.class)).getChild(UIMessagePreview.class)).isRendered();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void refreshBrowser(String accId) throws Exception {
        block5: {
            String username = MailUtils.getCurrentUser();
            MailService mailSrv = MailUtils.getMailService();
            try {
                Account acc = mailSrv.getAccountById(username, accId);
                if (acc != null) break block5;
                UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
                try {
                    String selectedAccId = ((UISelectAccount)uiPortlet.findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
                    if (!MailUtils.isFieldEmpty((String)selectedAccId)) {
                        this.init(selectedAccId);
                        break block5;
                    }
                    this.init(null);
                    ((UIMessagePreview)uiPortlet.findFirstComponentOfType(UIMessagePreview.class)).setMessage(null);
                }
                catch (Exception e) {
                    this.init(null);
                    ((UIMessagePreview)uiPortlet.findFirstComponentOfType(UIMessagePreview.class)).setMessage(null);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public String getAccountId() {
        return this.accountId_;
    }

    public String getSelectedMessageId() throws Exception {
        return this.selectedMessageId_;
    }

    public void setSelectedMessageId(String messageId) {
        this.selectedMessageId_ = messageId;
    }

    public String getSelectedFolderId() {
        return this.selectedFolderId_;
    }

    public void setSelectedFolderId(String folderId) {
        this.selectedFolderId_ = folderId;
    }

    public String getSelectedTagId() {
        return this.selectedTagId_;
    }

    public void setSelectedTagId(String tagId) {
        this.selectedTagId_ = tagId;
    }

    public boolean selectedSpamFolder() throws Exception {
        return this.getSelectedFolderId() != null ? this.getSelectedFolderId().equals(Utils.generateFID((String)this.accountId_, (String)Utils.FD_SPAM, (boolean)false)) : false;
    }

    public boolean selectedDraftFolder() throws Exception {
        return this.getSelectedFolderId() != null ? this.getSelectedFolderId().equals(Utils.generateFID((String)this.accountId_, (String)Utils.FD_DRAFTS, (boolean)false)) : false;
    }

    public boolean selectedSentFolder() throws Exception {
        return this.getSelectedFolderId() != null ? this.getSelectedFolderId().equals(Utils.generateFID((String)this.accountId_, (String)Utils.FD_SENT, (boolean)false)) : false;
    }

    public String getViewQuery() {
        return this.viewQuery_;
    }

    public void setViewQuery(String view) {
        this.viewQuery_ = view;
    }

    public MessageFilter getMessageFilter() {
        return this.msgFilter_;
    }

    public void setMessageFilter(MessageFilter msgFilter) {
        this.msgFilter_ = msgFilter;
    }

    public String getSortedBy() {
        return this.sortedBy_;
    }

    public void setSortedBy(String sortedBy) {
        this.sortedBy_ = sortedBy;
    }

    public boolean isAscending() {
        return this.isAscending_;
    }

    public void setAscending(boolean b) {
        this.isAscending_ = b;
    }

    public MessagePageList getMessagePageList() {
        return this.pageList_;
    }

    public List<Message> getMessageList() throws Exception {
        return new ArrayList<Message>(this.messageList_.values());
    }

    public void setMessagePageList(MessagePageList pageList) throws Exception {
        this.setMessagePageList(pageList, 0L);
    }

    public void setMessagePageList(MessagePageList pageList, long currentPage) throws Exception {
        this.pageList_ = pageList;
        if (currentPage > 0L) {
            this.updateList(currentPage);
        } else {
            this.updateList();
        }
    }

    public void updateList() throws Exception {
        long page = 1L;
        if (this.pageList_ != null) {
            page = this.pageList_.getCurrentPage();
        }
        this.updateList(page);
    }

    public void updateList(long page) throws Exception {
        this.getChildren().clear();
        this.messageList_.clear();
        if (this.pageList_ != null) {
            List msgList = new ArrayList();
            try {
                msgList = this.pageList_.getPage(page, MailUtils.getCurrentUser());
                if (page > 1L && msgList.size() == 0) {
                    msgList = this.pageList_.getPage(page - 1L, MailUtils.getCurrentUser());
                }
            }
            catch (Exception e) {
                String username = MailUtils.getCurrentUser();
                MailService mailSrv = MailUtils.getMailService();
                try {
                    this.setMessagePageList(mailSrv.getMessagePageList(username, this.getMessageFilter()));
                }
                catch (Exception ex) {
                    this.setMessagePageList(null);
                }
                return;
            }
            for (Message message : msgList) {
                String encodeId = Utils.encodeMailId((String)message.getId());
                UIFormCheckBoxInput uiCheckBox = new UIFormCheckBoxInput(encodeId, encodeId, (Object)false);
                this.addUIFormInput((UIFormInput)uiCheckBox);
                this.messageList_.put(message.getId(), message);
            }
        }
    }

    public List<Message> getCheckedMessage() throws Exception {
        return this.getCheckedMessage(true);
    }

    public List<Message> getCheckedMessage(boolean includeGroupedMsgs) throws Exception {
        ArrayList<Message> checkedList = new ArrayList<Message>();
        for (Message msg : this.getMessageList()) {
            UIFormCheckBoxInput uiCheckbox = this.getUIFormCheckBoxInput(Utils.encodeMailId((String)msg.getId()));
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            checkedList.add(msg);
            if (this.viewMode != 3 || !includeGroupedMsgs) continue;
            for (String childMsgId : msg.getGroupedMessageIds()) {
                Message childMsg = (Message)this.messageList_.get(childMsgId);
                if (childMsg == null || childMsg.getFolders()[0].equals(Utils.generateFID((String)this.accountId_, (String)Utils.FD_SENT, (boolean)false))) continue;
                checkedList.add(childMsg);
            }
        }
        return checkedList;
    }

    public List<Tag> getTags(Message msg) throws Exception {
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String username = uiPortlet.getCurrentUser();
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        try {
            if (msg.getTags() != null && msg.getTags().length > 0) {
                for (int i = 0; i < msg.getTags().length; ++i) {
                    Tag tag = mailSrv.getTag(username, this.accountId_, msg.getTags()[i]);
                    tagList.add(tag);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tagList;
    }

    public List<Folder> getFolders(Message msg) throws Exception {
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String username = uiPortlet.getCurrentUser();
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        ArrayList<Folder> folderList = new ArrayList<Folder>();
        String[] folders = msg.getFolders();
        if (folders != null && folders.length > 0) {
            for (int i = 0; i < folders.length; ++i) {
                Folder folder = mailSrv.getFolder(username, this.accountId_, folders[i]);
                folderList.add(folder);
            }
        }
        return folderList;
    }

    private void toggleMsgStatus(String username, String accountId, List<Message> msgs, String folderId, boolean value) throws Exception {
        MailUtils.getMailService().toggleMessageProperty(username, accountId, msgs, folderId, Utils.EXO_ISUNREAD, value);
    }

    public boolean isShowUnread(Message msg) throws Exception {
        boolean showUnread = false;
        try {
            if (this.viewMode == 3 && msg.getGroupedMessageIds().size() > 0) {
                for (String id : msg.getGroupedMessageIds()) {
                    Message m = (Message)this.messageList_.get(id);
                    if (!m.isUnread()) continue;
                    showUnread = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return showUnread;
    }

    public void filterMessage(String viewQuery) throws Exception {
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        this.setViewQuery(viewQuery);
        String username = uiPortlet.getCurrentUser();
        String accountId = ((UISelectAccount)uiPortlet.findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
        MessageFilter msgFilter = this.getMessageFilter();
        msgFilter.setAccountId(accountId);
        msgFilter.setOrderBy(this.getSortedBy());
        msgFilter.setAscending(this.isAscending_);
        msgFilter.setViewQuery(this.getViewQuery());
        if (!msgFilter.getName().equals("Search")) {
            String[] stringArray;
            String[] stringArray2;
            msgFilter.setText("");
            if (this.getSelectedFolderId() == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = this.getSelectedFolderId();
            }
            msgFilter.setFolder(stringArray2);
            if (this.getSelectedTagId() == null) {
                stringArray = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = this.getSelectedTagId();
            }
            msgFilter.setTag(stringArray);
        }
        msgFilter.setHasStructure(false);
        this.setMessagePageList(mailSrv.getMessagePageList(username, msgFilter));
    }

    static /* synthetic */ void access$000(UIMessageList x0, String x1, String x2, List x3, String x4, boolean x5) throws Exception {
        x0.toggleMsgStatus(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    static /* synthetic */ boolean access$200(UIMessageList x0) {
        return x0.isAscending_;
    }
}

