/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.cs.common.webui.UIPopupComponent;
import org.exoplatform.mail.webui.UIFormDateTimePicker;
import org.exoplatform.mail.webui.UISelectFolder;
import org.exoplatform.mail.webui.popup.UIAdvancedSearchForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAdvancedSearchForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIAdvancedSearchForm
extends UIForm
implements UIPopupComponent {
    public static final String ALL_FOLDER_SEARCH = "All folder";
    public static final String SELECT_FOLDER_SEARCH = "folder";
    public static final String FIELD_FROM_SEARCH = "from-field";
    public static final String FIELD_TO_SEARCH = "to-field";
    public static final String FIELD_SUBJECT_SEARCH = "subject-field";
    public static final String FIELD_CONTENT_SEARCH = "message-content";
    public static final String SEARCH_SUBJECT_CONDITION = "filter-subject-condition".intern();
    public static final String SEARCH_TO_CONDITION = "filter-to-condition".intern();
    public static final String SEARCH_FROM_CONDITION = "filter-from-condition".intern();
    public static final String SEARCH_BODY_CONDITION = "filter-body-condition".intern();
    public static final String SEARCH_PRIORITY = "search-priority".intern();
    public static final String SEARCH_HAS_STAR = "search-has-star".intern();
    public static final String SEARCH_HAS_ATTACH = "search-has-attachment".intern();
    public static final String FIELD_FROM_DATE = "from-date";
    public static final String FIELD_TO_DATE = "to-date";
    public List<Contact> ToContacts = new ArrayList();

    public List<Contact> getToContacts() {
        return this.ToContacts;
    }

    public void setToContacts(List<Contact> contactList) {
        this.ToContacts = contactList;
    }

    public void init(String accountId) throws Exception {
        UISelectFolder uiSelectFolder = new UISelectFolder();
        this.addUIFormInput((UIFormInputSet)uiSelectFolder);
        uiSelectFolder.init(accountId);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_TO_SEARCH, null, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_FROM_SEARCH, null, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_SUBJECT_SEARCH, null, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_CONTENT_SEARCH, null, null));
        UIFormDateTimePicker uiFormDateTimeInputBeforeDate = new UIFormDateTimePicker(FIELD_FROM_DATE, FIELD_FROM_DATE, null, false);
        UIFormDateTimePicker uiFormDateTimeInputAfterDate = new UIFormDateTimePicker(FIELD_TO_DATE, FIELD_TO_DATE, null, false);
        this.addUIFormInput((UIFormInput)uiFormDateTimeInputBeforeDate);
        this.addUIFormInput((UIFormInput)uiFormDateTimeInputAfterDate);
        ArrayList<SelectItemOption> options1 = new ArrayList<SelectItemOption>();
        options1.add(new SelectItemOption("contains", (Object)String.valueOf(0)));
        options1.add(new SelectItemOption("doesn't contain", (Object)String.valueOf(1)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SEARCH_BODY_CONDITION, SEARCH_BODY_CONDITION, options1));
        ArrayList<SelectItemOption> options2 = new ArrayList<SelectItemOption>();
        options2.add(new SelectItemOption("contains", (Object)String.valueOf(0)));
        options2.add(new SelectItemOption("doesn't contain", (Object)String.valueOf(1)));
        options2.add(new SelectItemOption("is", (Object)String.valueOf(2)));
        options2.add(new SelectItemOption("is not", (Object)String.valueOf(3)));
        options2.add(new SelectItemOption("starts with", (Object)String.valueOf(4)));
        options2.add(new SelectItemOption("ends with", (Object)String.valueOf(5)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SEARCH_TO_CONDITION, SEARCH_TO_CONDITION, options2));
        ArrayList<SelectItemOption> options3 = new ArrayList<SelectItemOption>();
        options3.add(new SelectItemOption("contains", (Object)String.valueOf(0)));
        options3.add(new SelectItemOption("doesn't contain", (Object)String.valueOf(1)));
        options3.add(new SelectItemOption("is", (Object)String.valueOf(2)));
        options3.add(new SelectItemOption("is not", (Object)String.valueOf(3)));
        options3.add(new SelectItemOption("starts with", (Object)String.valueOf(4)));
        options3.add(new SelectItemOption("ends with", (Object)String.valueOf(5)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SEARCH_FROM_CONDITION, SEARCH_FROM_CONDITION, options3));
        ArrayList<SelectItemOption> options4 = new ArrayList<SelectItemOption>();
        options4.add(new SelectItemOption("contains", (Object)String.valueOf(0)));
        options4.add(new SelectItemOption("doesn't contain", (Object)String.valueOf(1)));
        options4.add(new SelectItemOption("is", (Object)String.valueOf(2)));
        options4.add(new SelectItemOption("is not", (Object)String.valueOf(3)));
        options4.add(new SelectItemOption("starts with", (Object)String.valueOf(4)));
        options4.add(new SelectItemOption("ends with", (Object)String.valueOf(5)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SEARCH_SUBJECT_CONDITION, SEARCH_SUBJECT_CONDITION, options4));
        ArrayList<SelectItemOption> priorities = new ArrayList<SelectItemOption>();
        priorities.add(new SelectItemOption(" -- Choose Priority -- ", (Object)"priority.0"));
        priorities.add(new SelectItemOption("High", (Object)("priority." + String.valueOf(1L))));
        priorities.add(new SelectItemOption("Normal", (Object)("priority." + String.valueOf(3L))));
        priorities.add(new SelectItemOption("Low", (Object)("priority." + String.valueOf(5L))));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SEARCH_PRIORITY, SEARCH_PRIORITY, priorities));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(SEARCH_HAS_STAR, SEARCH_HAS_STAR, (Object)false));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(SEARCH_HAS_ATTACH, SEARCH_HAS_ATTACH, (Object)false));
    }

    public void setFieldEmailFrom(String value) {
        this.getUIStringInput(FIELD_FROM_SEARCH).setValue((Object)value);
    }

    public String getFieldEmailFrom() {
        return (String)this.getUIStringInput(FIELD_FROM_SEARCH).getValue();
    }

    public String getFromCondition() throws Exception {
        return (String)this.getUIFormSelectBox(SEARCH_FROM_CONDITION).getValue();
    }

    public void setFieldEmailTo(List<SelectItemOption<String>> options) {
        this.getUIFormSelectBox(FIELD_TO_SEARCH).setOptions(options);
    }

    public String getFieldEmailTo() {
        return (String)this.getUIStringInput(FIELD_TO_SEARCH).getValue();
    }

    public String getToCondition() throws Exception {
        return (String)this.getUIFormSelectBox(SEARCH_TO_CONDITION).getValue();
    }

    public String getSelectedFolder() {
        return ((UISelectFolder)this.getChild(UISelectFolder.class)).getSelectedValue();
    }

    public void setSelectedFolder(String folderId) {
        ((UISelectFolder)this.getChild(UISelectFolder.class)).setSelectedValue(folderId);
    }

    public String getSubject() {
        return (String)this.getUIStringInput(FIELD_SUBJECT_SEARCH).getValue();
    }

    public String getSubjectCondition() throws Exception {
        return (String)this.getUIFormSelectBox(SEARCH_SUBJECT_CONDITION).getValue();
    }

    public String getMessageBody() {
        return (String)this.getUIStringInput(FIELD_CONTENT_SEARCH).getValue();
    }

    public String getBodyCondition() throws Exception {
        return (String)this.getUIFormSelectBox(SEARCH_BODY_CONDITION).getValue();
    }

    public Calendar getFromDate() {
        return this.getUIFormDateTimePicker(FIELD_FROM_DATE).getCalendar();
    }

    public String getInputFromDate() {
        return (String)this.getUIFormDateTimePicker(FIELD_FROM_DATE).getValue();
    }

    public String getInputToDate() {
        return (String)this.getUIFormDateTimePicker(FIELD_TO_DATE).getValue();
    }

    public UIFormDateTimePicker getUIFormDateTimePicker(String id) {
        return (UIFormDateTimePicker)this.findComponentById(id);
    }

    public Calendar getToDate() {
        return this.getUIFormDateTimePicker(FIELD_TO_DATE).getCalendar();
    }

    public boolean hasStar() {
        return this.getUIFormCheckBoxInput(SEARCH_HAS_STAR).isChecked();
    }

    public boolean hasAttachment() {
        return this.getUIFormCheckBoxInput(SEARCH_HAS_ATTACH).isChecked();
    }

    public long getPriority() {
        String value = (String)this.getUIFormSelectBox(SEARCH_PRIORITY).getValue();
        return Long.valueOf(value.substring(value.indexOf(".") + 1), value.length());
    }

    public void resetFields() {
        this.reset();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String[] getActions() {
        return new String[]{"Search", "Cancel"};
    }
}

