/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.StatusInfo;
import org.exoplatform.mail.webui.UIFetchingBar;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UIMessageList;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/UIFetchingBar.gtmpl", events={@EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={UpdateListActionListener.class}), @EventConfig(listeners={UpdateFolderActionListener.class})})
public class UIFetchingBar
extends UIForm {
    private static final Log log = ExoLogger.getExoLogger(UIFetchingBar.class);
    protected boolean isShown_ = false;
    private MailService mailService = MailUtils.getMailService();
    private StatusInfo statusInfo;

    public StatusInfo loadStatusInfo() {
        block3: {
            UIMailPortlet mailportlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
            try {
                CheckingInfo ckInfo = this.mailService.getCheckingInfo(mailportlet.getRemoteUser(), mailportlet.getAccountId());
                if (ckInfo != null) {
                    this.statusInfo = ckInfo.getStatus();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Exception in method loadStatusInfo", (Throwable)e);
            }
        }
        return this.statusInfo;
    }

    public boolean isShown() {
        return this.statusInfo != null && this.statusInfo.getStatus() != 200;
    }

    public boolean showStatusText() {
        return this.statusInfo != null && this.statusInfo.getStatus() != 102 && this.statusInfo.getStatus() != 103 && this.statusInfo.getStatus() != 104 && this.statusInfo.getStatus() != 202;
    }

    public boolean showStopIcon() {
        return this.statusInfo != null && this.statusInfo.getStatus() != 102 && this.statusInfo.getStatus() != 103 && this.statusInfo.getStatus() != 104 && this.statusInfo.getStatus() != 200 && this.statusInfo.getStatus() != 202;
    }

    public boolean showStoppingIcon() {
        if (this.statusInfo != null) {
            return !this.showStopIcon() && this.statusInfo.getStatus() == 202;
        }
        return false;
    }

    public boolean showLoadingIcon() {
        if (this.statusInfo != null) {
            return this.statusInfo.getStatus() != 200 && this.statusInfo.getStatus() != 102 && this.statusInfo.getStatus() != 103 && this.statusInfo.getStatus() != 104;
        }
        return false;
    }

    public boolean showWarningMessage() {
        if (this.statusInfo != null) {
            return !this.showStatusText() && this.statusInfo.getStatus() != 202;
        }
        return false;
    }

    public void setIsShown(boolean b) {
        this.isShown_ = b;
    }

    public boolean isUpdate() throws Exception {
        UIMessageList uiMsgList = (UIMessageList)((UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class)).findFirstComponentOfType(UIMessageList.class);
        return uiMsgList.getMessagePageList() == null || uiMsgList.getMessagePageList().getCurrentPage() <= 1L && uiMsgList.getMessagePageList().getAvailablePage() <= 1L;
    }
}

