/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.exoplatform.cs.common.webui.UIPopupComponent;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.popup.UIImageForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormUploadInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class})})
public class UIImageForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_UPLOAD = "upload".intern();
    public static final String[] imageTypes = new String[]{".gif", ".jpg", ".jpeg", ".tiff", ".bmp", ".png"};

    public UIImageForm() throws Exception {
        this.setMultiPart(true);
        int sizeLimit = MailUtils.getLimitUploadSize();
        if (sizeLimit == -1) {
            this.addUIFormInput((UIFormInput)new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD, true));
        } else {
            this.addUIFormInput((UIFormInput)new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD, sizeLimit, true));
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getDonwloadLink(String fileName, ByteArrayInputStream inputStream) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)inputStream, "image");
        dresource.setDownloadName(fileName);
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }
}

