/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.mail.DataCache;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.webui.popup.UITagForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormColorPicker;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/UITagForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITagForm
extends UIForm
implements UIPopupComponent {
    public static final String SELECT_AVAIABLE_TAG = "tag-name";
    public static final String TAG_COLOR = "choose-color";
    public static final String TAG_MESSAGE = "TagMessage";
    private Map<String, Message> messageMap = new HashMap();
    private Map<String, Tag> tagMap = new HashMap();
    private List<String> checkedTagList = null;

    public void setTagList(List<Tag> tagList) throws Exception {
        this.tagMap.clear();
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SELECT_AVAIABLE_TAG, SELECT_AVAIABLE_TAG, null).addValidator(SpecialCharacterValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormColorPicker(TAG_COLOR, TAG_COLOR));
        for (Tag tag : tagList) {
            UIFormCheckBoxInput uiCheckBox = new UIFormCheckBoxInput(tag.getName(), tag.getName(), null);
            if (this.checkedTagList != null && this.checkedTagList.size() > 0 && this.checkedTagList.contains(tag.getName())) {
                uiCheckBox.setChecked(true);
            }
            this.addUIFormInput((UIFormInput)uiCheckBox);
            this.tagMap.put(tag.getName(), tag);
        }
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public String[] getActions() {
        return new String[]{"Add", "Remove", "Cancel"};
    }

    public List<Tag> getTagList() {
        return new ArrayList<Tag>(this.tagMap.values());
    }

    public void setMessageList(List<Message> messageList) throws Exception {
        this.messageMap.clear();
        DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
        String username = MailUtils.getCurrentUser();
        String accountId = dataCache.getSelectedAccountId();
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        for (Message msg : messageList) {
            String subject = msg.getSubject() != null ? msg.getSubject() : "";
            String mesSub = this.getLabel("subject") + " : " + (subject.length() >= 30 ? subject.substring(0, 30) + "..." : subject);
            UIFormInputInfo uiTags = new UIFormInputInfo(TAG_MESSAGE, TAG_MESSAGE, null);
            String tags = "";
            if (msg.getTags() != null && msg.getTags().length > 0) {
                this.checkedTagList = new ArrayList();
                for (int i = 0; i < msg.getTags().length; ++i) {
                    if (i > 0) {
                        tags = tags + ", ";
                    }
                    Tag tag = mailSrv.getTag(username, accountId, msg.getTags()[i]);
                    tags = tags + "[" + tag.getName() + "]";
                    this.checkedTagList.add(tag.getName());
                }
            } else {
                tags = this.getLabel("no-tag");
            }
            uiTags.setName(mesSub);
            uiTags.setValue((Object)tags);
            this.addUIFormInput((UIFormInput)uiTags);
            this.messageMap.put(msg.getId(), msg);
        }
    }

    public List<Message> getMessageList() {
        return new ArrayList<Message>(this.messageMap.values());
    }

    public List<Tag> getCheckedTags() throws Exception {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (Tag tag : this.getTagList()) {
            UIFormCheckBoxInput checkbox = (UIFormCheckBoxInput)this.getChildById(tag.getName());
            if (checkbox == null || !checkbox.isChecked()) continue;
            tagList.add(tag);
        }
        return tagList;
    }

    public String getSelectedColor() {
        return (String)((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).getValue();
    }

    public void setSelectedColor(String value) {
        ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setValue(value);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

