/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rest.client.openfire;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jivesoftware.util.JiveGlobals;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    private static UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(JiveGlobals.getXMLProperty((String)"provider.authorizedUser.name"), JiveGlobals.getXMLProperty((String)"provider.authorizedUser.password"));

    Utils() {
    }

    static Response doGet(URL url) throws HttpException, IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)usernamePasswordCredentials);
        GetMethod get = new GetMethod(url.toString());
        get.setDoAuthentication(true);
        int status = httpClient.executeMethod((HttpMethod)get);
        Document resDoc = null;
        try {
            if (get.getResponseBody().length > 0) {
                resDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(get.getResponseBodyAsStream());
            }
        }
        catch (Exception e) {
            throw new HttpException("XML parsing error : " + e);
        }
        finally {
            get.releaseConnection();
        }
        return new Response(status, resDoc);
    }

    static Response doPost(URL url) throws HttpException, IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)usernamePasswordCredentials);
        PostMethod post = new PostMethod(url.toString());
        post.setDoAuthentication(true);
        int status = httpClient.executeMethod((HttpMethod)post);
        Document resDoc = null;
        try {
            if (post.getResponseBody().length > 0) {
                resDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(post.getResponseBodyAsStream());
            }
        }
        catch (Exception e) {
            throw new HttpException("XML parsing error : " + e);
        }
        finally {
            post.releaseConnection();
        }
        return new Response(status, resDoc);
    }

    static Response doGet(URL url, HashMap<String, String> params) throws HttpException, IOException {
        if (params == null || params.size() == 0) {
            return Utils.doGet(url);
        }
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)usernamePasswordCredentials);
        String _url = url.toString();
        Set<String> key_set = params.keySet();
        _url = _url + (key_set.size() > 0 ? "?" : "");
        for (String key : key_set) {
            _url = _url + key + "=" + params.get(key);
        }
        GetMethod get = new GetMethod(_url);
        get.setDoAuthentication(true);
        int status = httpClient.executeMethod((HttpMethod)get);
        Document resDoc = null;
        try {
            if (get.getResponseBody().length > 0) {
                resDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(get.getResponseBodyAsStream());
            }
        }
        catch (Exception e) {
            throw new HttpException("XML parsing error : " + e);
        }
        finally {
            get.releaseConnection();
        }
        return new Response(status, resDoc);
    }

    static Response doPost(URL url, HashMap<String, String> params) throws HttpException, IOException {
        if (params == null || params.size() == 0) {
            return Utils.doPost(url);
        }
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)usernamePasswordCredentials);
        PostMethod post = new PostMethod(url.toString());
        post.setDoAuthentication(true);
        Set<String> key_set = params.keySet();
        for (String key : key_set) {
            post.setParameter(key, params.get(key));
        }
        int status = httpClient.executeMethod((HttpMethod)post);
        Document resDoc = null;
        try {
            if (post.getResponseBody().length > 0) {
                resDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(post.getResponseBodyAsStream());
            }
        }
        catch (Exception e) {
            throw new HttpException("XML parsing error : " + e);
        }
        finally {
            post.releaseConnection();
        }
        return new Response(status, resDoc);
    }

    static Map<String, String> parseQuery(List<String> l) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (l != null && l.size() > 0) {
            for (String s : l) {
                int eq = s.indexOf(61);
                if (eq <= 0) continue;
                String key = s.substring(0, eq).trim();
                String value = s.substring(eq + 1, s.length()).trim();
                m.put(key, value);
            }
        }
        return m;
    }

    static class Response {
        private final int status_;
        private final Document d_;

        public Response(int status, Document d) {
            this.status_ = status;
            this.d_ = d;
        }

        public int getStatus() {
            return this.status_;
        }

        public Document getResponseDoc() {
            return this.d_;
        }
    }
}

