/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rest.client.openfire;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.rest.client.openfire.Utils;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;

public class ExoAuthProvider
implements AuthProvider {
    private static final String AUTHENTICATION_URL = "eXo.provider.exoAuthProvider.authenticationURL";
    private static final String AUTHENTICATION_METHOD = "eXo.provider.exoAuthProvider.authenticationMethod";
    private static final String AUTHENTICATION_PARAMS = "eXo.provider.exoAuthProvider.authenticationParams";
    private final String authURL_;
    private final String authMethod_;
    private final Map<String, String> authParams_;

    public ExoAuthProvider() {
        String t = JiveGlobals.getXMLProperty((String)AUTHENTICATION_URL);
        this.authURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.authMethod_ = JiveGlobals.getXMLProperty((String)AUTHENTICATION_METHOD);
        this.authParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)AUTHENTICATION_PARAMS));
    }

    public void authenticate(String user, String pass) throws UnauthorizedException {
        Utils.Response resp;
        block5: {
            String url = this.authURL_;
            String method = this.authMethod_;
            HashMap<String, String> params = new HashMap<String, String>(this.authParams_);
            params.put("username", user);
            params.put("password", pass);
            resp = null;
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block5;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block5;
                }
                throw new UnauthorizedException("Authentication filed : Configuration error, only HTTP methods 'POST' or 'GET' allowed, but found '" + this.authMethod_ + "'.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UnauthorizedException("Authentication filed : " + e);
            }
        }
        if (resp.getStatus() != 200) {
            throw new UnauthorizedException("Authentication filed for user " + user + ". Returned status : " + resp.getStatus());
        }
    }

    public void authenticate(String user, String token, String digest) throws UnauthorizedException {
        throw new UnsupportedOperationException();
    }

    public String getPassword(String arg0) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isDigestSupported() {
        return true;
    }

    public boolean isPlainSupported() {
        return true;
    }

    public void setPassword(String user, String pass) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsPasswordRetrieval() {
        return false;
    }
}

