/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.rest.transformer.SerializableEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipListXMLEntity
implements SerializableEntity {
    private final Collection<Membership> memberships_;
    private final String baseURI_;
    private String username_;

    public MembershipListXMLEntity(Collection<Membership> memberships, String baseURI) {
        this.memberships_ = memberships;
        this.baseURI_ = baseURI;
    }

    public MembershipListXMLEntity(Collection<Membership> memberships, String username, String baseURI) {
        this.memberships_ = memberships;
        this.username_ = username;
        this.baseURI_ = baseURI;
    }

    public void writeObject(OutputStream out) throws IOException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(out);
            xsw.writeStartDocument();
            xsw.writeStartElement("memberships");
            xsw.writeDefaultNamespace("http://exoplatform.org/organization/rest");
            xsw.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
            if (this.username_ != null) {
                xsw.writeAttribute("user-name", this.username_);
            }
            for (Membership m : this.memberships_) {
                xsw.writeStartElement("membership");
                xsw.writeAttribute("http://www.w3.org/1999/xlink", "href", this.baseURI_ + "/organization/membership/" + m.getId() + "/?output=xml&command=info");
                xsw.writeStartElement("id");
                xsw.writeCharacters(m.getId());
                xsw.writeEndElement();
                xsw.writeStartElement("type");
                xsw.writeCharacters(m.getMembershipType());
                xsw.writeEndElement();
                xsw.writeStartElement("group-id");
                xsw.writeCharacters(m.getGroupId());
                xsw.writeEndElement();
                xsw.writeStartElement("user-name");
                xsw.writeCharacters(m.getUserName());
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

