/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.rest.transformer.SerializableEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipTypesListXMLEntity
implements SerializableEntity {
    private final Collection<MembershipType> membershipTypes_;

    public MembershipTypesListXMLEntity(Collection<MembershipType> membershipTypes) {
        this.membershipTypes_ = membershipTypes;
    }

    public void writeObject(OutputStream out) throws IOException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(out);
            xsw.writeStartDocument();
            xsw.writeStartElement("membership-types");
            xsw.writeDefaultNamespace("http://exoplatform.org/organization/rest");
            for (MembershipType mt : this.membershipTypes_) {
                xsw.writeStartElement("membership-type");
                xsw.writeAttribute("name", mt.getName());
                xsw.writeStartElement("owner");
                xsw.writeCharacters(mt.getOwner());
                xsw.writeEndElement();
                xsw.writeStartElement("description");
                xsw.writeCharacters(mt.getDescription());
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

