/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import java.util.ArrayList;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class ContactDataInitialize
extends SpaceListenerPlugin {
    private static final Log log = ExoLogger.getLogger(ContactDataInitialize.class);
    public static final String ADDRESSBOOK_ID_PREFIX = "ContactGroupInSpace".intern();
    private final InitParams params;

    public ContactDataInitialize(InitParams params) {
        this.params = params;
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        String portletName = "";
        try {
            portletName = this.params.getValueParam("portletName").getValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!portletName.equals(event.getSource())) {
            return;
        }
        try {
            String firstMem = null;
            Space space = event.getSpace();
            PortalContainer manager = PortalContainer.getInstance();
            OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            ((ComponentRequestLifecycle)oService).startRequest((ExoContainer)manager);
            ArrayList<String> receivedUsers = new ArrayList<String>();
            for (User u : oService.getUserHandler().findUsersByGroup(space.getGroupId()).getAll()) {
                Membership m = oService.getMembershipHandler().findMembershipByUserGroupAndType(u.getUserName(), space.getGroupId(), "manager");
                if (m != null && firstMem == null) {
                    firstMem = u.getUserName();
                    continue;
                }
                receivedUsers.add(u.getUserName());
            }
            ((ComponentRequestLifecycle)oService).endRequest((ExoContainer)manager);
            ContactService contactService = (ContactService)PortalContainer.getComponent(ContactService.class);
            String addrBookId = ADDRESSBOOK_ID_PREFIX + space.getId();
            AddressBook book = null;
            try {
                book = contactService.getPersonalAddressBook(firstMem, addrBookId);
            }
            catch (Exception e) {
                book = null;
            }
            if (book == null) {
                book = new AddressBook();
                book.setId(addrBookId);
                book.setName(space.getName() + " [sharing for Space]");
                book.setDescription("AddressBook for Social Space: " + space.getName());
                book.setEditPermissionGroups(new String[]{space.getGroupId()});
                book.setViewPermissionGroups(new String[]{space.getGroupId()});
                contactService.saveAddressBook(firstMem, book, true);
                contactService.shareAddressBook(firstMem, addrBookId, receivedUsers);
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
        }
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }
}

