/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.group;

import java.io.Serializable;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.configuration.AbstractConfigurationUpdate;
import org.rhq.core.domain.resource.group.ResourceGroup;

@DiscriminatorColumn(name="DTYPE")
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONFIG_GROUP_UPDATE_ID_SEQ")
@Table(name="RHQ_CONFIG_GROUP_UPDATE")
public abstract class AbstractAggregateConfigurationUpdate
extends AbstractConfigurationUpdate
implements Serializable {
    @GeneratedValue(generator="SEQ", strategy=GenerationType.SEQUENCE)
    @Id
    private int id;
    @JoinColumn(name="GROUP_ID", referencedColumnName="ID")
    @ManyToOne
    private ResourceGroup group;
    public static final String MIXED_VALUES_MARKER = "~ Mixed Values ~";

    protected AbstractAggregateConfigurationUpdate() {
    }

    protected AbstractAggregateConfigurationUpdate(ResourceGroup group, String subjectName) {
        super(subjectName);
        this.group = group;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ResourceGroup getGroup() {
        return this.group;
    }

    public void setGroup(ResourceGroup group) {
        this.group = group;
    }

    protected void appendToStringInternals(StringBuilder str) {
        super.appendToStringInternals(str);
        str.append(", id=").append(this.id);
        str.append(", resourceGroup=").append(this.group);
    }
}

