/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPPart;

public abstract class SOAPMessage {
    private HashMap properties = new HashMap();
    public static final String CHARACTER_SET_ENCODING = "javax.xml.soap.character-set-encoding";
    public static final String WRITE_XML_DECLARATION = "javax.xml.soap.write-xml-declaration";

    public abstract void addAttachmentPart(AttachmentPart var1);

    public abstract AttachmentPart createAttachmentPart();

    public AttachmentPart createAttachmentPart(DataHandler datahandler) {
        AttachmentPart part = this.createAttachmentPart();
        part.setDataHandler(datahandler);
        return part;
    }

    public AttachmentPart createAttachmentPart(Object content, String contentType) {
        AttachmentPart part = this.createAttachmentPart();
        part.setContent(content, contentType);
        return part;
    }

    public Object getProperty(String property) throws SOAPException {
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) throws SOAPException {
        this.properties.put(property, value);
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        SOAPEnvelope soapEnvelope;
        SOAPPart soapPart = this.getSOAPPart();
        if (soapPart != null && (soapEnvelope = soapPart.getEnvelope()) != null) {
            SOAPBody soapBody = soapEnvelope.getBody();
            return soapBody;
        }
        throw new SOAPException("Cannot obtain SOAPBody from SOAPMessage");
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        SOAPEnvelope soapEnvelope;
        SOAPPart soapPart = this.getSOAPPart();
        if (soapPart != null && (soapEnvelope = soapPart.getEnvelope()) != null) {
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            return soapHeader;
        }
        throw new SOAPException("Cannot obtain SOAPHeader from SOAPMessage");
    }

    public abstract String getContentDescription();

    public abstract void setContentDescription(String var1);

    public abstract MimeHeaders getMimeHeaders();

    public abstract SOAPPart getSOAPPart();

    public abstract void removeAllAttachments();

    public abstract void removeAttachments(MimeHeaders var1);

    public abstract int countAttachments();

    public abstract Iterator getAttachments();

    public abstract AttachmentPart getAttachment(SOAPElement var1) throws SOAPException;

    public abstract Iterator getAttachments(MimeHeaders var1);

    public abstract void saveChanges() throws SOAPException;

    public abstract boolean saveRequired();

    public abstract void writeTo(OutputStream var1) throws SOAPException, IOException;
}

