/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;

public class DataStoreFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$DataStoreFactory == null ? (class$org$apache$juddi$datastore$DataStoreFactory = DataStoreFactory.class$("org.apache.juddi.datastore.DataStoreFactory")) : class$org$apache$juddi$datastore$DataStoreFactory));
    private static final String IMPL_KEY = "juddi.dataStore";
    private static final String DEFAULT_IMPL = "org.apache.juddi.datastore.jdbc.JDBCDataStore";
    private static Class implClass = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$DataStoreFactory;

    public static DataStore getDataStore() {
        DataStore dataStore = null;
        try {
            if (implClass == null) {
                implClass = DataStoreFactory.loadImplClass();
            }
            if (implClass == null) {
                throw new RegistryException("The registry is not configured correctly.");
            }
            dataStore = (DataStore)implClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Exception while attempting to instantiate the implementation of DataStore: " + implClass.getName() + "\n" + e.getMessage()));
            log.error((Object)e);
        }
        return dataStore;
    }

    private static synchronized Class loadImplClass() {
        if (implClass != null) {
            return implClass;
        }
        String className = Config.getStringProperty(IMPL_KEY, DEFAULT_IMPL);
        log.debug((Object)("DataStore Implementation = " + className));
        try {
            implClass = Loader.getClassForName(className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The registry is not configured correctly. The specified DataStore class '" + className + "' was not found in " + "classpath."));
            log.error((Object)e);
        }
        return implClass;
    }

    public static void main(String[] args) {
        int i;
        int connCount = 10;
        DataStore[] stores = new DataStore[connCount];
        for (i = 0; i < connCount; ++i) {
            stores[i] = DataStoreFactory.getDataStore();
            if (stores[i] != null) {
                System.out.println("Got a DataStore: " + stores[i].getClass().getName());
                continue;
            }
            System.out.println("Sorry - A DataStore object could not be created.");
        }
        for (i = 0; i < connCount; ++i) {
            if (stores[i] != null) {
                stores[i].release();
                System.out.println("DataStore " + i + " released.");
                continue;
            }
            System.out.println("DataStore " + i + " was never successfully created.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

