/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.logging.Logger;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContextState;
import org.chromattic.core.NameKind;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.PropertyMap;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.info.NodeTypeInfo;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.metamodel.mapping.NodeAttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityContext
extends ObjectContext {
    private static final Logger log = Logger.getLogger(EntityContext.class);
    final ObjectMapper<EntityContext> mapper;
    final Object object;
    final PropertyMap properties;
    final Map<ObjectMapper<EmbeddedContext>, EmbeddedContext> embeddeds;
    EntityContextState state = null;

    EntityContext(ObjectMapper<EntityContext> mapper, EntityContextState state) throws RepositoryException {
        this.mapper = mapper;
        this.object = mapper.createObject(this);
        this.state = state;
        this.properties = new PropertyMap(this);
        this.embeddeds = new HashMap<ObjectMapper<EmbeddedContext>, EmbeddedContext>();
    }

    public Node getNode() {
        return this.state.getNode();
    }

    public DomainSession getSession() {
        return this.state.getSession();
    }

    public Status getStatus() {
        return this.state.getStatus();
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public EntityContext getEntity() {
        return this;
    }

    @Override
    public NodeTypeInfo getTypeInfo() {
        EntityContextState state = this.getEntity().state;
        return state.getTypeInfo();
    }

    public String decodeName(String name, NameKind nameKind) {
        try {
            return this.state.getSession().getDomain().decodeName(this, name, nameKind);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public String encodeName(String name, NameKind nameKind) {
        return this.state.getSession().getDomain().encodeName(this, name, nameKind);
    }

    public <T> T adapt(Class<T> adaptedClass) {
        if (adaptedClass.isInstance(this.object)) {
            return adaptedClass.cast(this.object);
        }
        EmbeddedContext embeddedCtx = this.getEmbedded(adaptedClass);
        if (embeddedCtx != null) {
            return adaptedClass.cast(embeddedCtx.getObject());
        }
        return null;
    }

    public void addMixin(EmbeddedContext mixinCtx) {
        this.state.getSession().addMixin(this, mixinCtx);
    }

    public EmbeddedContext getEmbedded(Class<?> embeddedClass) {
        return this.state.getSession().getEmbedded(this, embeddedClass);
    }

    public String getAttribute(NodeAttributeType type) {
        DomainSession session = this.state.getSession();
        switch (type) {
            case NAME: {
                return session.getName(this);
            }
            case ID: {
                return this.state.getId();
            }
            case PATH: {
                return this.state.getPath();
            }
            case WORKSPACE_NAME: {
                return session.sessionWrapper.getSession().getWorkspace().getName();
            }
        }
        throw new AssertionError();
    }

    public void remove() {
        this.state.getSession().remove(this);
    }

    public <T> Iterator<T> getReferents(String name, Class<T> filterClass, LinkType linkType) {
        return this.state.getSession().getReferents(this, name, filterClass, linkType);
    }

    public String getName() {
        return this.getAttribute(NodeAttributeType.NAME);
    }

    public String getId() {
        return this.getAttribute(NodeAttributeType.ID);
    }

    public String getPath() {
        return this.getAttribute(NodeAttributeType.PATH);
    }

    public void setName(String name) {
        this.state.getSession().setName(this, name);
    }

    public EntityContext getReferenced(String name, LinkType linkType) {
        return this.state.getSession().getReferenced(this, name, linkType);
    }

    public void setReferenced(String name, EntityContext referencedCtx, LinkType linkType) {
        DomainSession session = this.state.getSession();
        session.setReferenced(this, name, referencedCtx, linkType);
    }

    public boolean addReference(String name, EntityContext referentCtx, LinkType linkType) {
        DomainSession session = this.state.getSession();
        return session.setReferenced(referentCtx, name, this, linkType);
    }

    public Map<String, Object> getPropertyMap() {
        return this.properties;
    }

    public void removeChild(String name) {
        if (this.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException("Can only insert/remove a child of a persistent object");
        }
        this.state.getSession().removeChild(this, name);
    }

    public void orderBefore(EntityContext srcCtx, EntityContext dstCtx) {
        this.state.getSession().orderBefore(this, srcCtx, dstCtx);
    }

    public void addChild(EntityContext childCtx) {
        if (childCtx.getStatus() != Status.TRANSIENT && childCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalArgumentException("The child does not have the good state to be added " + childCtx);
        }
        String name = childCtx.getName();
        this.addChild(name, childCtx);
    }

    public void addChild(String name, EntityContext childCtx) {
        if (childCtx.getStatus() == Status.PERSISTENT) {
            this.state.getSession().move(childCtx, this);
        } else {
            this.state.getSession().persist(this, childCtx, name);
        }
    }

    public EntityContext getChild(String name) {
        return this.state.getSession().getChild(this, name);
    }

    public <T> Iterator<T> getChildren(Class<T> filterClass) {
        return this.state.getSession().getChildren(this, filterClass);
    }

    public EntityContext getParent() {
        return this.state.getSession().getParent(this);
    }

    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        return this.mapper.invoke(this, method, args);
    }

    public String toString() {
        return "EntityContext[state=" + this.state + ",mapper=" + this.mapper + "]";
    }
}

