/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcrom.JcrFile;
import org.jcrom.JcrMappingException;
import org.jcrom.annotations.JcrBaseVersionCreated;
import org.jcrom.annotations.JcrBaseVersionName;
import org.jcrom.annotations.JcrCheckedout;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrName;
import org.jcrom.annotations.JcrParentNode;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrProperty;
import org.jcrom.annotations.JcrReference;
import org.jcrom.annotations.JcrSerializedProperty;
import org.jcrom.annotations.JcrUUID;
import org.jcrom.annotations.JcrVersionCreated;
import org.jcrom.annotations.JcrVersionName;
import org.jcrom.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Validator {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);

    Validator() {
    }

    static Set<Class> validate(Class c, boolean dynamicInstantiation) {
        HashSet<Class> validClasses = new HashSet<Class>();
        Validator.validateInternal(c, validClasses, dynamicInstantiation);
        return validClasses;
    }

    private static void validateInternal(Class c, Set<Class> validClasses, boolean dynamicInstantiation) {
        if (!validClasses.contains(c)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Processing class: " + c.getName());
            }
            validClasses.add(c);
            if (!c.isInterface() || !dynamicInstantiation) {
                Validator.validateFields(c, ReflectionUtils.getDeclaredAndInheritedFields(c), validClasses, dynamicInstantiation);
            }
        }
    }

    private static void validateFields(Class c, Field[] fields, Set<Class> validClasses, boolean dynamicInstantiation) {
        boolean foundNameField = false;
        boolean foundPathField = false;
        for (Field field : fields) {
            field.setAccessible(true);
            if (logger.isDebugEnabled()) {
                logger.debug("In [" + c.getName() + "]: Processing field: " + field.getName());
            }
            if (field.isAnnotationPresent(JcrProperty.class)) {
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    if (ReflectionUtils.isFieldParameterizedWithPropertyType(field)) continue;
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is a List annotated as @JcrProperty is not parameterized with a property type.");
                }
                if (ReflectionUtils.isPropertyType(field.getType())) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrProperty is not a valid JCR property (type is " + field.getType().getName() + ").");
            }
            if (field.isAnnotationPresent(JcrSerializedProperty.class)) {
                if (ReflectionUtils.implementsInterface(field.getType(), Serializable.class)) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrSerializedProperty does not implement java.io.Serializable (type is " + field.getType().getName() + ").");
            }
            if (field.isAnnotationPresent(JcrName.class)) {
                if (field.getType() != String.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrName must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
                foundNameField = true;
                continue;
            }
            if (field.isAnnotationPresent(JcrUUID.class)) {
                if (field.getType() == String.class) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrUUID must be of type java.lang.String, but is of type: " + field.getType().getName());
            }
            if (field.isAnnotationPresent(JcrPath.class)) {
                if (field.getType() != String.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrPath must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
                foundPathField = true;
                continue;
            }
            if (field.isAnnotationPresent(JcrBaseVersionName.class)) {
                if (field.getType() == String.class) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrBaseVersionName must be of type java.lang.String, but is of type: " + field.getType().getName());
            }
            if (field.isAnnotationPresent(JcrBaseVersionCreated.class)) {
                if (ReflectionUtils.isDateType(field.getType())) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrBaseVersionCreated must be of type java.util.Date / java.util.Calendar / java.sql.Timestamp, but is of type: " + field.getType().getName());
            }
            if (field.isAnnotationPresent(JcrVersionName.class)) {
                if (field.getType() == String.class) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrVersionName must be of type java.lang.String, but is of type: " + field.getType().getName());
            }
            if (field.isAnnotationPresent(JcrVersionCreated.class)) {
                if (ReflectionUtils.isDateType(field.getType())) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrVersionCreated must be of type java.util.Date / java.util.Calendar / java.sql.Timestamp, but is of type: " + field.getType().getName());
            }
            if (field.isAnnotationPresent(JcrCheckedout.class)) {
                if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrCheckedout must be of type boolean, but is of type: " + field.getType().getName());
            }
            if (field.isAnnotationPresent(JcrParentNode.class)) {
                Validator.validateInternal(field.getType(), validClasses, dynamicInstantiation);
                continue;
            }
            if (field.isAnnotationPresent(JcrChildNode.class)) {
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    Class paramClass = ReflectionUtils.getParameterizedClass(field);
                    if (paramClass != null) {
                        Validator.validateInternal(ReflectionUtils.getParameterizedClass(field), validClasses, dynamicInstantiation);
                        continue;
                    }
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrChildNode is a java.util.List that is not parameterised with a valid class type.");
                }
                if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                    Class keyParamClass = ReflectionUtils.getParameterizedClass(field, 0);
                    if (keyParamClass == null || keyParamClass != String.class) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrChildNode is a java.util.Map that is not parameterised with a java.lang.String key type.");
                    }
                    Class valueParamClass = ReflectionUtils.getParameterizedClass(field, 1);
                    if (valueParamClass != null && ReflectionUtils.isValidMapValueType(valueParamClass)) continue;
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrChildNode is a java.util.Map that is not parameterised with a valid value property type.");
                }
                Validator.validateInternal(field.getType(), validClasses, dynamicInstantiation);
                continue;
            }
            if (field.isAnnotationPresent(JcrFileNode.class)) {
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    if (ReflectionUtils.extendsClass(ReflectionUtils.getParameterizedClass(field), JcrFile.class)) continue;
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is a List annotated as @JcrFileNode is not parameterized with a JcrFile implementation.");
                }
                if (ReflectionUtils.extendsClass(field.getType(), JcrFile.class)) continue;
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrFileNode is of type that does not extend JcrFile: " + field.getType().getName());
            }
            if (!field.isAnnotationPresent(JcrReference.class)) continue;
            boolean foundUUID = false;
            for (Field refField : ReflectionUtils.getDeclaredAndInheritedFields(field.getType())) {
                if (!refField.isAnnotationPresent(JcrUUID.class)) continue;
                foundUUID = true;
            }
            if (!foundUUID) {
                throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrReference is of type that has no @JcrUUID: " + field.getType().getName());
            }
            Validator.validateInternal(field.getType(), validClasses, dynamicInstantiation);
        }
        if (!foundNameField) {
            throw new JcrMappingException("In [" + c.getName() + "]: No field is annotated with @JcrName.");
        }
        if (!foundPathField) {
            throw new JcrMappingException("In [" + c.getName() + "]: No field is annotated with @JcrPath.");
        }
    }
}

