/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;

public class OracleDBInitializer
extends StorageDBInitializer {
    public OracleDBInitializer(String containerName, Connection connection, String scriptPath, boolean multiDb) throws IOException {
        super(containerName, connection, scriptPath, multiDb);
    }

    protected boolean isSequenceExists(Connection conn, String sequenceName) throws SQLException {
        try {
            ResultSet srs = conn.createStatement().executeQuery("SELECT " + sequenceName + ".nextval FROM DUAL");
            if (srs.next()) {
                return true;
            }
            srs.close();
            return false;
        }
        catch (SQLException e) {
            if (e.getMessage().indexOf("ORA-02289") >= 0) {
                return false;
            }
            throw e;
        }
    }

    protected boolean isTriggerExists(Connection conn, String triggerName) throws SQLException {
        String sql = "SELECT COUNT(trigger_name) FROM all_triggers WHERE trigger_name = '" + triggerName + "'";
        ResultSet r = conn.createStatement().executeQuery(sql);
        if (r.next()) {
            return r.getInt(1) > 0;
        }
        return false;
    }

    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        try {
            conn.createStatement().executeUpdate("SELECT 1 FROM " + tableName);
            return true;
        }
        catch (SQLException e) {
            if (e.getMessage().indexOf("ORA-00942") >= 0) {
                return false;
            }
            throw e;
        }
    }

    protected boolean isIndexExists(Connection conn, String tableName, String indexName) throws SQLException {
        String sql = "SELECT COUNT(index_name) FROM all_indexes WHERE index_name='" + indexName + "'";
        ResultSet r = conn.createStatement().executeQuery(sql);
        if (r.next()) {
            return r.getInt(1) > 0;
        }
        return false;
    }
}

