/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import com.sun.xml.bind.api.JAXBRIContext;
import java.io.IOException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.jboss.ws.WSException;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.metadata.wsdl.DOMTypes;
import org.jboss.ws.tools.wsdl.WSDLGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JAXBWSDLGenerator
extends WSDLGenerator {
    private JAXBRIContext ctx;

    public JAXBWSDLGenerator(JAXBRIContext ctx) {
        this.ctx = ctx;
    }

    protected void processTypes() {
        for (String ns : this.ctx.getKnownNamespaceURIs()) {
            if (ns.length() <= 0) continue;
            this.wsdl.registerNamespaceURI(ns, null);
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            DOMTypes types = new DOMTypes(doc);
            final Element element = types.getElement();
            final Element throwAway = doc.createElement("throw-away");
            this.ctx.generateSchema(new SchemaOutputResolver(){

                public Result createOutput(String namespace, String file) throws IOException {
                    if (namespace != null && namespace.length() > 0 && JAXBWSDLGenerator.this.wsdl.getPrefix(namespace) == null) {
                        JAXBWSDLGenerator.this.wsdl.registerNamespaceURI(namespace, null);
                    }
                    DOMResult result = null;
                    if (namespace == null || namespace.length() == 0) {
                        result = new DOMResult(throwAway);
                        result.setSystemId("remove-me");
                    } else {
                        result = new DOMResult(element);
                        result.setSystemId("replace-me");
                    }
                    return result;
                }
            });
            this.removeSchemaLocations(element);
            this.wsdl.setWsdlTypes(types);
        }
        catch (Exception exception) {
            throw new WSException("Could not generate schema: " + exception.getMessage(), exception);
        }
    }

    private void removeSchemaLocations(Element element) {
        Element child = Util.getFirstChildElement(element);
        while (child != null) {
            if ("import".equals(child.getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(child.getNamespaceURI()) && "replace-me".equals(child.getAttribute("schemaLocation"))) {
                child.removeAttribute("schemaLocation");
            } else if ("import".equals(child.getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(child.getNamespaceURI()) && "remove-me".equals(child.getAttribute("schemaLocation"))) {
                element.removeChild(child);
            } else {
                this.removeSchemaLocations(child);
            }
            child = Util.getNextSiblingElement(child);
        }
    }
}

