/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.mail.Folder;
import javax.mail.Message;
import org.exoplatform.mail.service.DataStorage;
import org.exoplatform.mail.service.MimeMessageParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchMailContentThread
implements Runnable {
    private DataStorage storage_;
    private String username_;
    private String accountId_;
    private LinkedHashMap<Message, List<String>> msgMap_;
    private Folder folder_;
    private int numberMessage_ = 0;

    public FetchMailContentThread(DataStorage storage, LinkedHashMap<Message, List<String>> msgMap, int numberMessage, Folder folder, String username, String accountId) throws Exception {
        this.storage_ = storage;
        this.username_ = username;
        this.accountId_ = accountId;
        this.msgMap_ = msgMap;
        this.folder_ = folder;
        this.numberMessage_ = numberMessage;
    }

    @Override
    public void run() {
        try {
            this.downloadMailContent();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void downloadMailContent() throws Exception {
        int j = 0;
        ArrayList<Message> msgList = new ArrayList<Message>(this.msgMap_.keySet());
        if (!this.folder_.isOpen()) {
            this.folder_.open(2);
        }
        while (j < this.numberMessage_) {
            Message msg = (Message)msgList.get(j);
            this.storage_.saveTotalMessage(this.username_, this.accountId_, MimeMessageParser.getMessageId(msg), msg, null);
            ++j;
        }
    }

    public void stop() {
        try {
            if (this.folder_.isOpen()) {
                this.folder_.close(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

