/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.connectionfactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.AspectManager;
import org.jboss.jms.client.JBossConnectionFactory;
import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.plugin.LoadBalancingFactory;
import org.jboss.jms.client.plugin.LoadBalancingPolicy;
import org.jboss.jms.client.plugin.NoLoadBalancingLoadBalancingFactory;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.server.ConnectionFactoryManager;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.connectionfactory.JNDIBindings;
import org.jboss.jms.server.endpoint.ServerConnectionFactoryEndpoint;
import org.jboss.jms.server.endpoint.advised.ConnectionFactoryAdvised;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.ClusterNotification;
import org.jboss.messaging.core.contract.ClusterNotificationListener;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.util.CompatibleExecutor;
import org.jboss.messaging.util.ExecutorFactory;
import org.jboss.messaging.util.JBMThreadFactory;
import org.jboss.messaging.util.JNDIUtil;
import org.jboss.messaging.util.OrderedExecutorFactory;
import org.jboss.messaging.util.Version;
import org.jboss.remoting.InvokerLocator;

public class ConnectionFactoryJNDIMapper
implements ConnectionFactoryManager,
ClusterNotificationListener {
    private static final Logger log = Logger.getLogger(ConnectionFactoryJNDIMapper.class);
    private static boolean trace = log.isTraceEnabled();
    private static final ExecutorFactory executorFactory = new OrderedExecutorFactory(Executors.newCachedThreadPool(new JBMThreadFactory("conn-factory-jndi-mapper")));
    protected Context initialContext;
    protected ServerPeer serverPeer;
    private Map endpoints;
    private Map delegates;
    private Replicator replicator;
    private CompatibleExecutor notifyExecutor;

    public ConnectionFactoryJNDIMapper(ServerPeer serverPeer) throws Exception {
        this.serverPeer = serverPeer;
        this.endpoints = new HashMap();
        this.delegates = new HashMap();
        this.notifyExecutor = executorFactory.getExecutor("jbm-cf-jndimapper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerConnectionFactory(String uniqueName, String clientID, JNDIBindings jndiBindings, String locatorURI, boolean clientPing, int prefetchSize, boolean slowConsumers, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int dupsOKBatchSize, boolean supportsFailover, boolean supportsLoadBalancing, LoadBalancingFactory loadBalancingFactory, boolean strictTck, boolean sendAcksAsync) throws Exception {
        ConnectionFactoryAdvised advised;
        log.debug((Object)(this + " registering connection factory '" + uniqueName + "', bindings: " + jndiBindings));
        if (this.delegates.containsKey(uniqueName)) {
            throw new IllegalArgumentException("There's already a connection factory registered with name " + uniqueName);
        }
        String id = uniqueName;
        Version version = this.serverPeer.getVersion();
        ServerConnectionFactoryEndpoint endpoint = new ServerConnectionFactoryEndpoint(uniqueName, id, this.serverPeer, clientID, jndiBindings, prefetchSize, slowConsumers, defaultTempQueueFullSize, defaultTempQueuePageSize, defaultTempQueueDownCacheSize, dupsOKBatchSize, supportsFailover);
        this.endpoints.put(uniqueName, endpoint);
        DelegateSupport delegate = null;
        if (supportsFailover || supportsLoadBalancing) {
            this.setupReplicator();
        }
        if (supportsFailover && this.replicator == null) {
            log.info((Object)("supportsFailover attribute is true on connection factory: " + uniqueName + " but post office is non clustered. " + "So connection factory will *not* support failover"));
        }
        if (supportsLoadBalancing && this.replicator == null) {
            log.info((Object)("supportsLoadBalancing attribute is true on connection factory: " + uniqueName + " but post office is non clustered. " + "So connection factory will *not* support load balancing"));
        }
        boolean creatingClustered = (supportsFailover || supportsLoadBalancing) && this.replicator != null;
        boolean useStrict = this.serverPeer.isStrictTck() || strictTck;
        ClientConnectionFactoryDelegate localDelegate = new ClientConnectionFactoryDelegate(uniqueName, id, this.serverPeer.getServerPeerID(), locatorURI, version, clientPing, useStrict, sendAcksAsync);
        log.debug((Object)(this + " created local delegate " + localDelegate));
        if (creatingClustered) {
            Map localDelegates;
            boolean ok;
            if (!supportsLoadBalancing) {
                loadBalancingFactory = new NoLoadBalancingLoadBalancingFactory(localDelegate);
            }
            if (!(ok = this.sanityCheckFactories((localDelegates = this.replicator.get((Serializable)((Object)("CF_" + uniqueName)))).values()))) {
                String msg = "The remoting locator configuration for a particular clustered connection factory must be the same on each node in the cluster. We have detected that the configuration differs on this node. Please correct and redeploy the connection factory";
                log.error((Object)"The remoting locator configuration for a particular clustered connection factory must be the same on each node in the cluster. We have detected that the configuration differs on this node. Please correct and redeploy the connection factory");
                throw new IllegalArgumentException("The remoting locator configuration for a particular clustered connection factory must be the same on each node in the cluster. We have detected that the configuration differs on this node. Please correct and redeploy the connection factory");
            }
            delegate = this.createClusteredDelegate(uniqueName, localDelegates.values(), loadBalancingFactory, endpoint, supportsFailover);
            log.debug((Object)(this + " created clustered delegate " + delegate));
        } else {
            delegate = localDelegate;
        }
        log.trace((Object)(this + " adding delegates factory " + uniqueName + " pointing to " + delegate));
        this.delegates.put(uniqueName, delegate);
        this.rebindConnectionFactory(this.initialContext, jndiBindings, (ConnectionFactoryDelegate)((Object)delegate));
        AspectManager aspectManager = AspectManager.instance();
        synchronized (aspectManager) {
            advised = new ConnectionFactoryAdvised(endpoint);
        }
        Dispatcher.instance.registerTarget(id, advised);
        this.serverPeer.getConnectionManager().registerConnectionFactory(endpoint);
        if (this.replicator != null) {
            this.replicator.put((Serializable)((Object)("CF_" + uniqueName)), localDelegate);
        }
    }

    public synchronized void unregisterConnectionFactory(String uniqueName, boolean supportsFailover, boolean supportsLoadBalancing) throws Exception {
        ConnectionFactoryDelegate delegate;
        log.trace((Object)("ConnectionFactory " + uniqueName + " being unregistered"));
        ServerConnectionFactoryEndpoint endpoint = (ServerConnectionFactoryEndpoint)this.endpoints.remove(uniqueName);
        if (endpoint == null) {
            throw new IllegalArgumentException("Cannot find endpoint with name " + uniqueName);
        }
        JNDIBindings jndiBindings = endpoint.getJNDIBindings();
        if (jndiBindings != null) {
            List jndiNames = jndiBindings.getNames();
            for (String jndiName : jndiNames) {
                this.initialContext.unbind(jndiName);
                log.debug((Object)(jndiName + " unregistered"));
            }
        }
        if (trace) {
            log.trace((Object)("Removing delegate from delegates list with key=" + uniqueName + " at serverPeerID=" + this.serverPeer.getServerPeerID()));
        }
        if ((delegate = (ConnectionFactoryDelegate)this.delegates.remove(uniqueName)) == null) {
            throw new IllegalArgumentException("Cannot find factory with name " + uniqueName);
        }
        if (this.replicator != null) {
            this.replicator.remove((Serializable)((Object)("CF_" + uniqueName)));
        }
        Dispatcher.instance.unregisterTarget(endpoint.getID(), endpoint);
        this.serverPeer.getConnectionManager().unregisterConnectionFactory(endpoint);
    }

    public void start() throws Exception {
        this.initialContext = new InitialContext();
        log.debug((Object)"started");
    }

    public void stop() throws Exception {
        this.initialContext.close();
        this.notifyExecutor.shutdownNow();
        log.debug((Object)"stopped");
    }

    public void notify(final ClusterNotification notification) {
        log.debug((Object)(this + " received notification from node " + notification.nodeID));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NotifyRunner
        implements Runnable {
            NotifyRunner() {
            }

            @Override
            public void run() {
                try {
                    if (notification.type == 4 || notification.type == 5) {
                        Map failoverMap = ConnectionFactoryJNDIMapper.this.serverPeer.getPostOfficeInstance().getFailoverMap();
                        for (Map.Entry entry : ConnectionFactoryJNDIMapper.this.endpoints.entrySet()) {
                            String uniqueName = (String)entry.getKey();
                            Object del = ConnectionFactoryJNDIMapper.this.delegates.get(uniqueName);
                            if (del == null) {
                                throw new IllegalStateException("Cannot find connection factory with name " + uniqueName);
                            }
                            if (!(del instanceof ClientClusteredConnectionFactoryDelegate)) continue;
                            ((ClientClusteredConnectionFactoryDelegate)del).setFailoverMap(failoverMap);
                        }
                    } else if ((notification.type == 6 || notification.type == 7) && notification.data instanceof String && ((String)notification.data).startsWith("CF_")) {
                        log.debug((Object)("Updating CF information for " + notification.data));
                        String key = (String)notification.data;
                        String uniqueName = key.substring("CF_".length());
                        log.debug((Object)(this + " received '" + uniqueName + "' connection factory deploy / undeploy"));
                        ConnectionFactoryDelegate cfd = (ConnectionFactoryDelegate)ConnectionFactoryJNDIMapper.this.delegates.get(uniqueName);
                        if (cfd != null && !(cfd instanceof ClientConnectionFactoryDelegate)) {
                            ClientClusteredConnectionFactoryDelegate del = (ClientClusteredConnectionFactoryDelegate)cfd;
                            Map updatedReplicantMap = ConnectionFactoryJNDIMapper.this.replicator.get((Serializable)((Object)key));
                            List newDels = ConnectionFactoryJNDIMapper.this.sortDelegatesOnServerID(updatedReplicantMap.values());
                            ClientConnectionFactoryDelegate[] delArr = newDels.toArray(new ClientConnectionFactoryDelegate[newDels.size()]);
                            Map failoverMap = ConnectionFactoryJNDIMapper.this.serverPeer.getPostOfficeInstance().getFailoverMap();
                            del.setDelegates(delArr);
                            del.setFailoverMap(failoverMap);
                            ServerConnectionFactoryEndpoint endpoint = (ServerConnectionFactoryEndpoint)ConnectionFactoryJNDIMapper.this.endpoints.get(uniqueName);
                            if (endpoint == null) {
                                throw new IllegalStateException("Cannot find endpoint with name " + uniqueName);
                            }
                            ConnectionFactoryJNDIMapper.this.rebindConnectionFactory(ConnectionFactoryJNDIMapper.this.initialContext, endpoint.getJNDIBindings(), del);
                            endpoint.updateClusteredClients(delArr, failoverMap);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Failed to rebind connection factory", (Throwable)e);
                }
            }
        }
        this.notifyExecutor.execute(new NotifyRunner());
    }

    public void injectReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    public String toString() {
        return "Server[" + this.serverPeer.getServerPeerID() + "].ConnFactoryJNDIMapper";
    }

    private void setupReplicator() throws Exception {
        this.serverPeer.getPostOfficeInstance();
    }

    private ClientClusteredConnectionFactoryDelegate createClusteredDelegate(String uniqueName, Collection localDelegates, LoadBalancingFactory loadBalancingFactory, ServerConnectionFactoryEndpoint endpoint, boolean supportsFailover) throws Exception {
        log.trace((Object)(this + " creating a clustered ConnectionFactoryDelegate based on " + localDelegates));
        List sortedLocalDelegates = this.sortDelegatesOnServerID(localDelegates);
        ConnectionFactoryDelegate[] delegates = sortedLocalDelegates.toArray(new ClientConnectionFactoryDelegate[sortedLocalDelegates.size()]);
        Map failoverMap = this.serverPeer.getPostOfficeInstance().getFailoverMap();
        LoadBalancingPolicy lbp = loadBalancingFactory.createLoadBalancingPolicy(delegates);
        endpoint.updateTopology((ClientConnectionFactoryDelegate[])delegates, failoverMap);
        return new ClientClusteredConnectionFactoryDelegate(uniqueName, (ClientConnectionFactoryDelegate[])delegates, failoverMap, lbp, supportsFailover);
    }

    private void rebindConnectionFactory(Context ic, JNDIBindings jndiBindings, ConnectionFactoryDelegate delegate) throws NamingException {
        JBossConnectionFactory cf = new JBossConnectionFactory(delegate);
        if (jndiBindings != null) {
            List jndiNames = jndiBindings.getNames();
            for (String jndiName : jndiNames) {
                log.debug((Object)(this + " rebinding " + cf + " as " + jndiName));
                JNDIUtil.rebind(ic, jndiName, cf);
            }
        }
    }

    private List sortDelegatesOnServerID(Collection delegates) {
        ArrayList localDels = new ArrayList(delegates);
        Collections.sort(localDels, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                ClientConnectionFactoryDelegate del1 = (ClientConnectionFactoryDelegate)obj1;
                ClientConnectionFactoryDelegate del2 = (ClientConnectionFactoryDelegate)obj2;
                return del1.getServerID() - del2.getServerID();
            }
        });
        return localDels;
    }

    private boolean sanityCheckFactories(Collection factories) throws Exception {
        Iterator iter = factories.iterator();
        InvokerLocator prevLocator = null;
        while (iter.hasNext()) {
            ClientConnectionFactoryDelegate fact = (ClientConnectionFactoryDelegate)iter.next();
            String locatorString = fact.getServerLocatorURI();
            InvokerLocator locator = new InvokerLocator(locatorString);
            if (prevLocator != null) {
                if (!locator.getProtocol().equals(prevLocator.getProtocol())) {
                    log.error((Object)("Protocol to be used for connection factory does not match protocol specified at other nodes in the cluster " + locator.getProtocol() + ", " + prevLocator.getProtocol()));
                    return false;
                }
                Map prevParams = prevLocator.getParameters();
                Map params = locator.getParameters();
                if (prevParams.size() != params.size()) {
                    log.error((Object)"Locator for connection factory has different number of parameters");
                    return false;
                }
                for (Map.Entry entry : prevParams.entrySet()) {
                    String prevKey = (String)entry.getKey();
                    String prevValue = (String)entry.getValue();
                    String value = (String)params.get(prevKey);
                    if (value != null && prevValue.equals(value)) continue;
                    log.error((Object)"Locator param does not exist or has wrong value");
                    return false;
                }
            }
            prevLocator = locator;
        }
        return true;
    }
}

