/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.connectionfactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.messaging.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JNDIBindings {
    private Element delegate;
    private List names;

    public JNDIBindings(Element delegate) {
        this.parse(delegate);
        this.delegate = delegate;
    }

    public Element getDelegate() {
        return this.delegate;
    }

    public List getNames() {
        return this.names;
    }

    public String toString() {
        if (this.names == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = this.names.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private void parse(Element e) {
        if (!"bindings".equals(e.getNodeName())) {
            throw new IllegalArgumentException("The element is not a <bindings> element");
        }
        if (!e.hasChildNodes()) {
            this.names = Collections.EMPTY_LIST;
            return;
        }
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!"binding".equals(n.getNodeName())) continue;
            String text = XMLUtil.getTextContent(n).trim();
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(text);
        }
        if (this.names == null) {
            this.names = Collections.EMPTY_LIST;
        }
    }
}

