/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ejb.AbstractEnterpriseBeanProcessor;
import org.jboss.metadata.annotation.creator.ejb.AroundInvokeProcessor;
import org.jboss.metadata.annotation.creator.ejb.ImplicitLocalProcessor;
import org.jboss.metadata.annotation.creator.ejb.InitProcessor;
import org.jboss.metadata.annotation.creator.ejb.LocalHomeProcessor;
import org.jboss.metadata.annotation.creator.ejb.LocalProcessor;
import org.jboss.metadata.annotation.creator.ejb.RemoteHomeProcessor;
import org.jboss.metadata.annotation.creator.ejb.RemoteProcessor;
import org.jboss.metadata.annotation.creator.ejb.TimeoutProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionBeanProcessor
extends AbstractEnterpriseBeanProcessor<SessionBeanMetaData>
implements Creator<Class<?>, SessionBeanMetaData>,
Processor<EjbJar3xMetaData, Class<?>> {
    protected AbstractSessionBeanProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new LocalProcessor(finder));
        this.addTypeProcessor(new LocalHomeProcessor(finder));
        this.addTypeProcessor(new RemoteProcessor(finder));
        this.addTypeProcessor(new RemoteHomeProcessor(finder));
        this.addTypeProcessor(new ImplicitLocalProcessor(finder));
        this.addMethodProcessor(new InitProcessor(finder));
        this.addMethodProcessor(new TimeoutProcessor(finder));
        this.addMethodProcessor(new AroundInvokeProcessor(finder));
    }

    @Override
    public abstract SessionBeanMetaData create(Class<?> var1);

    protected SessionBeanMetaData create(Class<?> beanClass, String name, String mappedName, String description) {
        SessionBeanMetaData bean = new SessionBeanMetaData();
        bean.setEjbClass(beanClass.getName());
        String ejbName = name == null || name.length() == 0 ? beanClass.getSimpleName() : name;
        bean.setEjbName(ejbName);
        if (mappedName != null && mappedName.length() > 0) {
            bean.setMappedName(mappedName);
        }
        if (description != null && description.length() > 0) {
            DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
            DescriptionsImpl descriptions = new DescriptionsImpl();
            DescriptionImpl descriptionImpl = new DescriptionImpl();
            descriptionImpl.setDescription(description);
            descriptions.add(descriptionImpl);
            descriptionGroup.setDescriptions(descriptions);
            bean.setDescriptionGroup(descriptionGroup);
        }
        TransactionManagement txMgmt = this.finder.getAnnotation(beanClass, TransactionManagement.class);
        TransactionManagementType txType = TransactionManagementType.CONTAINER;
        if (txMgmt != null) {
            txType = txMgmt.value();
        }
        bean.setTransactionType(txType);
        return bean;
    }
}

