/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Pipe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioPipeSourceChannelImpl
implements StreamSourceChannel {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.pipe.source-channel");
    private final Pipe.SourceChannel channel;
    private final NioHandle handle;
    private final NioXnio nioXnio;
    private final IoHandler<? super StreamSourceChannel> handler;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private final Closeable mbeanHandle;

    public NioPipeSourceChannelImpl(Pipe.SourceChannel channel, IoHandler<? super StreamSourceChannel> handler, NioXnio nioXnio, Closeable mbeanHandle) throws IOException {
        this.channel = channel;
        this.handler = handler;
        this.nioXnio = nioXnio;
        this.mbeanHandle = mbeanHandle;
        this.handle = nioXnio.addReadHandler(channel, new Handler());
    }

    public int read(ByteBuffer dst) throws IOException {
        int ret = this.channel.read(dst);
        return ret;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long ret = this.channel.read(dsts);
        return ret;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = this.channel.read(dsts, offset, length);
        return ret;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            HandlerUtils.handleClosed(this.handler, this);
            this.nioXnio.removeManaged((Closeable)((Object)this));
            IoUtils.safeClose((Closeable)this.mbeanHandle);
            this.channel.close();
        }
    }

    public void suspendReads() {
        try {
            this.handle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeReads() {
        try {
            this.handle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void shutdownReads() throws IOException {
        this.channel.close();
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.channel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.channel, 1, time, timeUnit);
    }

    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    public Set<ChannelOption<?>> getOptions() {
        return Collections.emptySet();
    }

    public String toString() {
        return String.format("pipe source channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    private final class Handler
    implements Runnable {
        private Handler() {
        }

        public void run() {
            HandlerUtils.handleReadable(NioPipeSourceChannelImpl.this.handler, NioPipeSourceChannelImpl.this);
        }
    }
}

