/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class MapDataModel
extends DataModel
implements Serializable {
    private static final long serialVersionUID = -4888962547222002402L;
    private int rowIndex = -1;
    private Map data;
    private transient List<Map.Entry> entries;

    public MapDataModel() {
    }

    public MapDataModel(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("null map data");
        }
        this.setWrappedData(map);
    }

    public int getRowCount() {
        if (this.entries == null) {
            return -1;
        }
        return this.entries.size();
    }

    public Object getRowData() {
        if (this.entries == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this.entries.get(this.rowIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object getWrappedData() {
        return new AbstractMap(){

            public Set entrySet() {
                return new AbstractSet(){

                    public Iterator iterator() {
                        return MapDataModel.this.entries.iterator();
                    }

                    public int size() {
                        return MapDataModel.this.entries.size();
                    }
                };
            }
        };
    }

    public boolean isRowAvailable() {
        return this.entries != null && this.rowIndex >= 0 && this.rowIndex < this.entries.size();
    }

    public void setRowIndex(int newRowIndex) {
        if (newRowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + newRowIndex);
        }
        int oldRowIndex = this.rowIndex;
        this.rowIndex = newRowIndex;
        if (this.entries != null && oldRowIndex != newRowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent((DataModel)this, newRowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        this.data = (Map)data;
        this.entries = data == null ? null : new ArrayList(((Map)data).entrySet());
        int rowIndex = data != null ? 0 : -1;
        this.setRowIndex(rowIndex);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.rowIndex);
        oos.writeObject(this.data);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.rowIndex = ois.readInt();
        this.data = (Map)ois.readObject();
        this.entries = this.data == null ? null : new ArrayList(this.data.entrySet());
    }
}

