/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.jacorb.security.sas.GSSUPCredentialSpi;
import org.jacorb.security.sas.GSSUPNameSpi;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;

public final class GSSUPContextSpi
implements GSSContextSpi {
    private Provider provider = null;
    private Oid mechOid = null;
    private int lifetime;
    private boolean mutualAuth = false;
    private boolean relayDet = false;
    private boolean sequenceDet = false;
    private boolean credDeleg = false;
    private boolean anonymity = false;
    private boolean conf = false;
    private boolean integ = false;
    private boolean established = false;
    private ChannelBinding channelBinding = null;
    private GSSNameSpi targetName;
    private GSSCredentialSpi sourceCred;

    public GSSUPContextSpi(Provider provider, Oid oid, GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n) {
        this.provider = provider;
        this.mechOid = oid;
        this.targetName = gSSNameSpi;
        this.sourceCred = gSSCredentialSpi;
        this.lifetime = n;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void requestLifetime(int n) throws GSSException {
        this.lifetime = n;
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        this.mutualAuth = bl;
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        this.relayDet = bl;
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        this.sequenceDet = false;
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        this.credDeleg = bl;
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        this.anonymity = bl;
    }

    public void requestConf(boolean bl) throws GSSException {
        this.conf = bl;
    }

    public void requestInteg(boolean bl) throws GSSException {
        this.integ = bl;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.channelBinding = channelBinding;
    }

    public boolean getCredDelegState() {
        return this.credDeleg;
    }

    public boolean getMutualAuthState() {
        return this.mutualAuth;
    }

    public boolean getReplayDetState() {
        return this.relayDet;
    }

    public boolean getSequenceDetState() {
        return this.sequenceDet;
    }

    public boolean getAnonymityState() {
        return this.anonymity;
    }

    public boolean isTransferable() throws GSSException {
        return true;
    }

    public boolean isProtReady() {
        return false;
    }

    public boolean getConfState() {
        return this.conf;
    }

    public boolean getIntegState() {
        return this.integ;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public boolean isEstablished() {
        return this.established;
    }

    public GSSNameSpi getSrcName() throws GSSException {
        return this.sourceCred.getName();
    }

    public GSSNameSpi getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    public GSSCredentialSpi getDelegCred() throws GSSException {
        return null;
    }

    public byte[] initSecContext(InputStream inputStream, int n) throws GSSException {
        this.established = true;
        return ((Object)this.sourceCred.getName()).toString().getBytes();
    }

    public byte[] acceptSecContext(InputStream inputStream, int n) throws GSSException {
        this.established = true;
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            GSSUPNameSpi gSSUPNameSpi = new GSSUPNameSpi(this.provider, this.mechOid, byArray, null);
            this.sourceCred = new GSSUPCredentialSpi(this.provider, this.mechOid, gSSUPNameSpi, 0, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        return 0;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        return null;
    }

    public int wrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        return 0;
    }

    public void wrap(byte[] byArray, int n, int n2, OutputStream outputStream, MessageProp messageProp) throws GSSException {
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        return null;
    }

    public int unwrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        return 0;
    }

    public int unwrap(InputStream inputStream, byte[] byArray, int n, MessageProp messageProp) throws GSSException {
        return 0;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        return null;
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
    }

    public byte[] export() throws GSSException {
        return null;
    }

    public void dispose() throws GSSException {
        this.channelBinding = null;
        this.provider = null;
        this.mechOid = null;
    }
}

