/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.CalendarUpdateEventListener;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.RssData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CalendarService {
    public static final String ICALENDAR = "ICalendar(.ics)".intern();
    public static final String EXPORTEDCSV = "ExportedCsv(.csv)".intern();

    public List<CalendarCategory> getCategories(String var1) throws Exception;

    public List<GroupCalendarData> getCalendarCategories(String var1, boolean var2) throws Exception;

    public CalendarCategory getCalendarCategory(String var1, String var2) throws Exception;

    public void saveCalendarCategory(String var1, CalendarCategory var2, boolean var3) throws Exception;

    public CalendarCategory removeCalendarCategory(String var1, String var2) throws Exception;

    public Calendar getUserCalendar(String var1, String var2) throws Exception;

    public List<Calendar> getUserCalendars(String var1, boolean var2) throws Exception;

    public List<Calendar> getUserCalendarsByCategory(String var1, String var2) throws Exception;

    public void saveUserCalendar(String var1, Calendar var2, boolean var3) throws Exception;

    public Calendar removeUserCalendar(String var1, String var2) throws Exception;

    public void saveSharedCalendar(String var1, Calendar var2) throws Exception;

    public Calendar getGroupCalendar(String var1) throws Exception;

    public List<GroupCalendarData> getGroupCalendars(String[] var1, boolean var2, String var3) throws Exception;

    public void savePublicCalendar(Calendar var1, boolean var2, String var3) throws Exception;

    public Calendar removePublicCalendar(String var1) throws Exception;

    public List<EventCategory> getEventCategories(String var1) throws Exception;

    public void saveEventCategory(String var1, EventCategory var2, boolean var3) throws Exception;

    public void removeEventCategory(String var1, String var2) throws Exception;

    public EventCategory getEventCategory(String var1, String var2) throws Exception;

    public EventCategory getEventCategoryByName(String var1, String var2) throws Exception;

    public List<CalendarEvent> getUserEventByCalendar(String var1, List<String> var2) throws Exception;

    public List<CalendarEvent> getUserEvents(String var1, EventQuery var2) throws Exception;

    public CalendarEvent getEvent(String var1, String var2) throws Exception;

    public void saveUserEvent(String var1, String var2, CalendarEvent var3, boolean var4) throws Exception;

    public CalendarEvent removeUserEvent(String var1, String var2, String var3) throws Exception;

    public CalendarEvent getGroupEvent(String var1, String var2) throws Exception;

    public List<CalendarEvent> getGroupEventByCalendar(List<String> var1) throws Exception;

    public List<CalendarEvent> getPublicEvents(EventQuery var1) throws Exception;

    public void savePublicEvent(String var1, CalendarEvent var2, boolean var3) throws Exception;

    public CalendarEvent removePublicEvent(String var1, String var2) throws Exception;

    public void saveCalendarSetting(String var1, CalendarSetting var2) throws Exception;

    public CalendarSetting getCalendarSetting(String var1) throws Exception;

    public CalendarImportExport getCalendarImportExports(String var1);

    public String[] getExportImportType() throws Exception;

    public int generateRss(String var1, LinkedHashMap<String, Calendar> var2, RssData var3) throws Exception;

    public int generateRss(String var1, List<String> var2, RssData var3) throws Exception;

    public List<FeedData> getFeeds(String var1) throws Exception;

    public Node getRssHome(String var1) throws Exception;

    public EventPageList searchEvent(String var1, EventQuery var2, String[] var3) throws Exception;

    public Map<Integer, String> searchHightLightEvent(String var1, EventQuery var2, String[] var3) throws Exception;

    public void shareCalendar(String var1, String var2, List<String> var3) throws Exception;

    public GroupCalendarData getSharedCalendars(String var1, boolean var2) throws Exception;

    public List<CalendarEvent> getEvents(String var1, EventQuery var2, String[] var3) throws Exception;

    public void removeSharedCalendar(String var1, String var2) throws Exception;

    public void saveEventToSharedCalendar(String var1, String var2, CalendarEvent var3, boolean var4) throws Exception;

    public Map<String, String> checkFreeBusy(EventQuery var1) throws Exception;

    public int generateCalDav(String var1, LinkedHashMap<String, Calendar> var2, RssData var3) throws Exception;

    public int generateCalDav(String var1, List<String> var2, RssData var3) throws Exception;

    public void removeSharedEvent(String var1, String var2, String var3) throws Exception;

    public void moveEvent(String var1, String var2, String var3, String var4, List<CalendarEvent> var5, String var6) throws Exception;

    public void confirmInvitation(String var1, String var2, int var3, String var4, String var5, int var6) throws Exception;

    public void confirmInvitation(String var1, String var2, String var3, int var4, String var5, String var6, int var7) throws Exception;

    public void addListenerPlugin(CalendarUpdateEventListener var1) throws Exception;

    public void updateRss(String var1, String var2, CalendarImportExport var3) throws Exception;

    public void updateRss(String var1, String var2, CalendarImportExport var3, int var4) throws Exception;

    public void updateCalDav(String var1, String var2, CalendarImportExport var3) throws Exception;

    public void updateCalDav(String var1, String var2, CalendarImportExport var3, int var4) throws Exception;

    public int getTypeOfCalendar(String var1, String var2) throws Exception;

    public List<CalendarEvent> getSharedEventByCalendars(String var1, List<String> var2) throws Exception;

    public void removeFeedData(String var1, String var2);

    public ResourceBundle getResourceBundle() throws Exception;
}

