/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.temporary;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class ThreadLocalSessionProviderInitializedFilter
implements Filter {
    private ThreadLocalSessionProviderService providerService;
    private static final Log LOGGER = LogFactory.getLog((String)"jcr.ThreadLocalSessionProviderInitializedFilter");

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.providerService = (ThreadLocalSessionProviderService)container.getComponentInstanceOfType(ThreadLocalSessionProviderService.class);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String user = httpRequest.getRemoteUser();
        LOGGER.debug((Object)("Current user : " + user));
        SessionProvider provider = null;
        if (user != null) {
            Object identity = null;
            if (identity != null) {
                provider = new SessionProvider(null);
            } else {
                LOGGER.warn((Object)("Identity is null from Authentication Service for " + user + "."));
            }
        }
        if (provider == null) {
            LOGGER.warn((Object)"Create SessionProvider for anonymous.");
            provider = SessionProvider.createAnonimProvider();
        }
        this.providerService.setSessionProvider(null, provider);
        chain.doFilter(request, response);
        this.providerService.removeSessionProvider(null);
    }

    public void destroy() {
    }
}

