/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jboss.web.tomcat.service.session.AttributeBasedClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteredManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteredSessionValve;
import org.jboss.web.tomcat.service.session.FieldBasedClusteredSession;
import org.jboss.web.tomcat.service.session.InstantSnapshotManager;
import org.jboss.web.tomcat.service.session.IntervalSnapshotManager;
import org.jboss.web.tomcat.service.session.JBossCacheCluster;
import org.jboss.web.tomcat.service.session.JBossCacheManagerMBean;
import org.jboss.web.tomcat.service.session.JBossManager;
import org.jboss.web.tomcat.service.session.JvmRouteValve;
import org.jboss.web.tomcat.service.session.LockingValve;
import org.jboss.web.tomcat.service.session.SessionBasedClusteredSession;
import org.jboss.web.tomcat.service.session.SessionInvalidationTracker;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.service.session.SnapshotManager;
import org.jboss.web.tomcat.service.session.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactoryFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingAttributeGranularitySessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;
import org.jboss.web.tomcat.service.session.notification.ClusteredSessionNotificationCapability;
import org.jboss.web.tomcat.service.session.notification.ClusteredSessionNotificationCause;
import org.jboss.web.tomcat.service.session.notification.ClusteredSessionNotificationPolicy;
import org.jboss.web.tomcat.service.session.notification.IgnoreUndeployLegacyClusteredSessionNotificationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheManager<O extends OutgoingDistributableSessionData>
extends JBossManager
implements JBossCacheManagerMBean,
LocalDistributableSessionManager,
ClusteredManager<O> {
    private static final String info_ = "JBossCacheManager/1.0";
    private static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    private BatchingManager batchingManager;
    private DistributedCacheManager<O> proxy_;
    private final DistributedCacheManagerFactory distributedCacheManagerFactory;
    private Map<String, OwnedSessionUpdate> unloadedSessions_ = new ConcurrentHashMap<String, OwnedSessionUpdate>();
    private AtomicInteger passivatedCount_ = new AtomicInteger();
    private AtomicInteger maxPassivatedCount_ = new AtomicInteger();
    private Boolean useJK_;
    private boolean embedded_ = false;
    private SnapshotMode snapshotMode_ = null;
    private int snapshotInterval_ = 0;
    private ReplicationGranularity replicationGranularity_;
    private ReplicationTrigger replicationTrigger_;
    private Boolean replicationFieldBatchMode_;
    private ClassLoader tcl_;
    private SnapshotManager snapshotManager_;
    private String cacheConfigName_;
    private int maxUnreplicatedInterval_ = -1;
    private String notificationPolicyClass_;
    private ClusteredSessionNotificationPolicy notificationPolicy_;
    private ReplicationConfig replicationConfig_;
    private Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private Lock valveLock = new SemaphoreLock(this.semaphore);

    public JBossCacheManager() throws ClusteringNotSupportedException {
        this(DistributedCacheManagerFactoryFactory.getInstance().getDistributedCacheManagerFactory());
    }

    public JBossCacheManager(DistributedCacheManagerFactory distributedManagerFactory) {
        assert (distributedManagerFactory != null) : "distributedManagerFactory is null";
        this.distributedCacheManagerFactory = distributedManagerFactory;
    }

    @Override
    public void init(String name, JBossWebMetaData webMetaData) throws ClusteringNotSupportedException {
        Boolean batch;
        super.init(name, webMetaData);
        this.replicationConfig_ = webMetaData.getReplicationConfig();
        this.replicationTrigger_ = this.replicationConfig_.getReplicationTrigger();
        this.replicationGranularity_ = this.replicationConfig_.getReplicationGranularity();
        Boolean jk = this.replicationConfig_.getUseJK();
        if (jk != null) {
            this.useJK_ = jk;
        }
        this.replicationFieldBatchMode_ = (batch = this.replicationConfig_.getReplicationFieldBatchMode()) == null ? Boolean.TRUE : batch;
        this.setSnapshotMode(this.replicationConfig_.getSnapshotMode());
        Integer snapshotInt = this.replicationConfig_.getSnapshotInterval();
        this.setSnapshotInterval(snapshotInt == null ? 0 : snapshotInt);
        Integer maxUnrep = this.replicationConfig_.getMaxUnreplicatedInterval();
        if (maxUnrep != null) {
            this.maxUnreplicatedInterval_ = maxUnrep;
        }
        this.log_.debug((Object)("init(): replicationGranularity_ is " + this.replicationGranularity_ + " and replicationTrigger is " + this.replicationTrigger_ + " and replicationFieldBatchMode is " + this.replicationFieldBatchMode_ + " and useJK is " + this.useJK_ + " and snapshotMode is " + this.snapshotMode_ + " and snapshotInterval is " + this.snapshotInterval_));
        this.cacheConfigName_ = this.replicationConfig_.getCacheName();
        this.notificationPolicyClass_ = this.replicationConfig_.getSessionNotificationPolicy();
        this.initDistributedCacheManager();
        this.embedded_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocal(Session session) {
        ClusteredSession<OutgoingDistributableSessionData> clusterSess;
        ClusteredSession<OutgoingDistributableSessionData> clusteredSession = clusterSess = JBossCacheManager.uncheckedCastSession(session);
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.trace_) {
                this.log_.trace((Object)("Removing session from local store with id: " + realId));
            }
            try {
                clusterSess.removeMyselfLocal();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                SessionInvalidationTracker.sessionInvalidated(realId, this);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
                throw throwable;
            }
            SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
            SessionInvalidationTracker.sessionInvalidated(realId, this);
            this.sessions_.remove(realId);
            this.stats_.removeStats(realId);
            int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
            this.sessionExpired(timeAlive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeSession(Session baseSession) {
        boolean stored = false;
        if (baseSession != null && this.started_) {
            ClusteredSession<OutgoingDistributableSessionData> session;
            ClusteredSession<OutgoingDistributableSessionData> clusteredSession = session = JBossCacheManager.uncheckedCastSession(baseSession);
            synchronized (clusteredSession) {
                if (this.trace_) {
                    this.log_.trace((Object)("check to see if needs to store and replicate session with id " + session.getIdInternal()));
                }
                if (session.isValid() && (session.isSessionDirty() || session.getMustReplicateTimestamp())) {
                    String realId = session.getRealId();
                    long begin = System.currentTimeMillis();
                    session.notifyWillPassivate(ClusteredSessionNotificationCause.REPLICATION);
                    long elapsed = System.currentTimeMillis() - begin;
                    this.stats_.updatePassivationStats(realId, elapsed);
                    begin = System.currentTimeMillis();
                    this.processSessionRepl(session);
                    elapsed = System.currentTimeMillis() - begin;
                    stored = true;
                    this.stats_.updateReplicationStats(realId, elapsed);
                } else if (this.trace_) {
                    this.log_.trace((Object)("Session " + session.getIdInternal() + " did not require replication."));
                }
            }
        }
        return stored;
    }

    public void add(Session session) {
        if (session == null) {
            return;
        }
        if (!(session instanceof ClusteredSession)) {
            throw new IllegalArgumentException("You can only add instances of type ClusteredSession to this Manager. Session class name: " + session.getClass().getName());
        }
        this.add(JBossCacheManager.uncheckedCastSession(session), false);
    }

    public Session createEmptySession() {
        if (this.trace_) {
            this.log_.trace((Object)"Creating an empty ClusteredSession");
        }
        return this.createEmptyClusteredSession();
    }

    public Session createSession() {
        return this.createSession(null);
    }

    public Session createSession(String sessionId) {
        if (this.maxActiveAllowed_ != -1 && this.calcActiveSessions() >= this.maxActiveAllowed_) {
            if (this.trace_) {
                this.log_.trace((Object)("createSession(): active sessions = " + this.calcActiveSessions() + " and max allowed sessions = " + this.maxActiveAllowed_));
            }
            this.processExpirationPassivation();
            if (this.calcActiveSessions() >= this.maxActiveAllowed_) {
                this.rejectedCounter_.incrementAndGet();
                String msgEnd = sessionId == null ? "" : " id " + sessionId;
                throw new IllegalStateException("createSession(): number of active sessions exceeds the maximum limit: " + this.maxActiveAllowed_ + " when trying to create session" + msgEnd);
            }
        }
        ClusteredSession<OutgoingDistributableSessionData> session = this.createEmptyClusteredSession();
        session.setNew(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval_);
        session.setValid(true);
        String clearInvalidated = null;
        if (sessionId == null) {
            sessionId = this.getNextId();
            if (this.getUseJK()) {
                if (this.trace_) {
                    this.log_.trace((Object)("createSession(): useJK is true. Will append JvmRoute: " + this.getJvmRoute()));
                }
                sessionId = sessionId + "." + this.getJvmRoute();
            }
        } else {
            clearInvalidated = sessionId;
        }
        session.setId(sessionId);
        this.getDistributedCacheManager().sessionCreated(session.getRealId());
        session.tellNew(ClusteredSessionNotificationCause.CREATE);
        if (this.trace_) {
            this.log_.trace((Object)("Created a ClusteredSession with id: " + sessionId));
        }
        this.createdCounter_.incrementAndGet();
        SessionReplicationContext.bindSession(session, this.snapshotManager_);
        if (clearInvalidated != null) {
            SessionInvalidationTracker.clearInvalidatedSession(clearInvalidated, this);
        }
        return session;
    }

    public Session findSession(String id) {
        String realId = this.getRealId(id);
        ClusteredSession<? extends OutgoingDistributableSessionData> session = this.findLocalSession(realId);
        if (session == null && !SessionInvalidationTracker.isSessionInvalidated(realId, this)) {
            if (this.trace_) {
                this.log_.trace((Object)("Checking for session " + realId + " in the distributed cache"));
            }
            session = this.loadSession(realId);
        } else if (session != null && session.isOutdated()) {
            if (this.trace_) {
                this.log_.trace((Object)("Updating session " + realId + " from the distributed cache"));
            }
            this.loadSession(realId);
        }
        if (session != null) {
            SessionReplicationContext.bindSession(session, this.snapshotManager_);
            if (session.getNeedsPostReplicateActivation()) {
                session.notifyDidActivate(ClusteredSessionNotificationCause.REPLICATION);
            }
        }
        return session;
    }

    public Session[] findSessions() {
        if (this.unloadedSessions_.size() > 0) {
            HashSet<String> ids = new HashSet<String>(this.unloadedSessions_.keySet());
            if (this.trace_) {
                this.log_.trace((Object)("findSessions: loading sessions from distributed cache: " + ids));
            }
            for (String id : ids) {
                this.loadSession(id);
            }
        }
        return this.findLocalSessions();
    }

    public String getInfo() {
        return info_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        ClusteredSession<OutgoingDistributableSessionData> clusterSess;
        ClusteredSession<OutgoingDistributableSessionData> clusteredSession = clusterSess = JBossCacheManager.uncheckedCastSession(session);
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.trace_) {
                this.log_.trace((Object)("Removing session from store with id: " + realId));
            }
            try {
                clusterSess.removeMyself();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                SessionInvalidationTracker.sessionInvalidated(realId, this);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
                throw throwable;
            }
            SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
            SessionInvalidationTracker.sessionInvalidated(realId, this);
            this.sessions_.remove(realId);
            this.stats_.removeStats(realId);
            int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
            this.sessionExpired(timeAlive);
        }
    }

    @Override
    public DistributedCacheManager<O> getDistributedCacheManager() {
        return this.proxy_;
    }

    @Override
    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval_;
    }

    @Override
    public ClusteredSessionNotificationPolicy getNotificationPolicy() {
        return this.notificationPolicy_;
    }

    @Override
    public ReplicationTrigger getReplicationTrigger() {
        return this.replicationTrigger_;
    }

    @Override
    public void start() throws LifecycleException {
        this.log_ = Logger.getLogger((String)(this.getClass().getName() + "." + this.getContainer().getName().replaceAll("/", "")));
        if (this.embedded_) {
            this.startEmbedded();
        } else {
            this.startUnembedded();
        }
        if (!this.semaphore.tryAcquire()) {
            this.log_.debug((Object)"Opening up LockingValve");
            this.semaphore.release(Integer.MAX_VALUE);
        } else {
            this.semaphore.release();
        }
        this.log_.debug((Object)"Started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws LifecycleException {
        if (!this.started_) {
            throw new IllegalStateException("Manager not started");
        }
        this.log_.debug((Object)"Stopping");
        if (this.semaphore.tryAcquire()) {
            try {
                this.log_.debug((Object)"Closing off LockingValve");
                this.semaphore.acquire(0x7FFFFFFE);
            }
            catch (InterruptedException e) {
                this.semaphore.release();
                throw new LifecycleException((Throwable)e);
            }
        }
        AtomicBoolean atomicBoolean = this.backgroundProcessAllowed;
        synchronized (atomicBoolean) {
            this.backgroundProcessAllowed.set(false);
        }
        this.stopExtensions();
        this.resetStats();
        this.lifecycle_.fireLifecycleEvent("before_stop", (Object)this);
        this.clearSessions();
        this.tcl_ = null;
        this.proxy_.stop();
        this.proxy_ = null;
        this.batchingManager = null;
        this.snapshotManager_.stop();
        this.sessions_.clear();
        this.unloadedSessions_.clear();
        this.passivatedCount_.set(0);
        this.started_ = false;
        this.lifecycle_.fireLifecycleEvent("after_stop", (Object)this);
        this.unregisterManagerMBean();
    }

    @Override
    public void expireSession(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session != null) {
            session.expire();
        }
    }

    @Override
    public String getCacheConfigName() {
        return this.cacheConfigName_;
    }

    @Override
    public String getCreationTime(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session == null) {
            this.log_.info((Object)("getCreationTime(): Session " + sessionId + " not found"));
            return "";
        }
        return new Date(session.getCreationTime()).toString();
    }

    @Override
    public int getDuplicates() {
        return this.duplicates_.get();
    }

    @Override
    public String getLastAccessedTime(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session == null) {
            this.log_.info((Object)("getLastAccessedTime(): Session " + sessionId + " not found"));
            return "";
        }
        return new Date(session.getLastAccessedTime()).toString();
    }

    @Override
    public String getSessionAttribute(String sessionId, String key) {
        Object attr = null;
        ClusteredSession<OutgoingDistributableSessionData> session = JBossCacheManager.uncheckedCastSession(this.findSession(sessionId));
        if (session != null) {
            attr = session.getAttribute(key);
        }
        return attr == null ? null : attr.toString();
    }

    @Override
    public long getMaxPassivatedSessionCount() {
        return this.maxPassivatedCount_.get();
    }

    @Override
    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval_ = maxUnreplicatedInterval;
    }

    @Override
    public long getPassivatedSessionCount() {
        return this.passivatedCount_.get();
    }

    @Override
    public long getPassivationMaxIdleTime() {
        return this.passivationMaxIdleTime_;
    }

    @Override
    public long getPassivationMinIdleTime() {
        return this.passivationMinIdleTime_;
    }

    @Override
    public ReplicationGranularity getReplicationGranularity() {
        return this.replicationGranularity_;
    }

    @Override
    public int getSnapshotInterval() {
        return this.snapshotInterval_;
    }

    @Override
    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode_;
    }

    @Override
    public boolean getUseJK() {
        return this.useJK_ == null ? false : this.useJK_;
    }

    @Override
    public boolean isPassivationEnabled() {
        return this.passivationMode_ && this.proxy_.isPassivationEnabled();
    }

    @Override
    public Boolean isReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode_;
    }

    @Override
    public String listLocalSessionIds() {
        return this.reportSessionIds(this.sessions_.keySet());
    }

    @Override
    public String listSessionIds() {
        HashSet<String> ids = new HashSet<String>(this.sessions_.keySet());
        ids.addAll(this.unloadedSessions_.keySet());
        return this.reportSessionIds(ids);
    }

    public String getContextName() {
        return this.getContainer().getName();
    }

    public String getHostName() {
        return this.getContainer().getParent().getName();
    }

    public ClassLoader getApplicationClassLoader() {
        return this.tcl_;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyRemoteInvalidation(String realId) {
        ClusteredSession session = (ClusteredSession)this.sessions_.remove(realId);
        if (session == null) {
            if (this.unloadedSessions_.remove(realId) != null && this.trace_) {
                this.log_.trace((Object)("Removed entry for session " + realId + " from unloaded session map"));
            }
            this.stats_.removeStats(realId);
            return;
        }
        boolean notify = false;
        boolean localCall = false;
        boolean localOnly = true;
        ContextClassLoaderSwitcher.SwitchContext switcher = null;
        try {
            SessionInvalidationTracker.suspend();
            switcher = JBossCacheManager.getContextClassLoaderSwitcher().getSwitchContext();
            switcher.setClassLoader(this.tcl_);
            session.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.INVALIDATE);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SessionInvalidationTracker.resume();
            this.stats_.removeStats(realId);
            if (switcher == null) throw throwable;
            switcher.reset();
            throw throwable;
        }
        SessionInvalidationTracker.resume();
        this.stats_.removeStats(realId);
        if (switcher == null) return;
        switcher.reset();
    }

    public void notifyLocalAttributeModification(String realId) {
        ClusteredSession session = (ClusteredSession)this.sessions_.get(realId);
        if (session != null) {
            session.sessionAttributesDirty();
        } else {
            this.log_.warn((Object)("Received local attribute notification for " + realId + " but session is not locally active"));
        }
    }

    public void sessionActivated() {
        int pc = this.passivatedCount_.decrementAndGet();
        if (pc < 0) {
            this.passivatedCount_.incrementAndGet();
        }
    }

    public boolean sessionChangedInDistributedCache(String realId, String dataOwner, int distributedVersion, long timestamp, DistributableSessionMetadata metadata) {
        boolean updated = true;
        ClusteredSession<? extends OutgoingDistributableSessionData> session = this.findLocalSession(realId);
        if (session != null) {
            updated = session.setVersionFromDistributedCache(distributedVersion);
            if (updated && this.trace_) {
                this.log_.trace((Object)("session in-memory data is invalidated for id: " + realId + " new version: " + distributedVersion));
            }
        } else {
            int maxLife = metadata == null ? this.getMaxInactiveInterval() : metadata.getMaxInactiveInterval();
            OwnedSessionUpdate existing = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(dataOwner, timestamp, maxLife, false));
            if (existing == null) {
                this.calcActiveSessions();
                if (this.trace_) {
                    this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
                }
            } else if (this.trace_) {
                this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
            }
        }
        return updated;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval_ = snapshotInterval;
    }

    public void setSnapshotMode(SnapshotMode snapshotMode) {
        this.snapshotMode_ = snapshotMode;
    }

    public void setUseJK(boolean useJK) {
        this.useJK_ = useJK;
    }

    public void setReplicationGranularity(ReplicationGranularity granularity) {
        this.replicationGranularity_ = granularity;
    }

    public String getReplicationGranularityString() {
        return this.replicationGranularity_ == null ? null : this.replicationGranularity_.toString();
    }

    public void setReplicationGranularityString(String granularity) {
        this.setReplicationGranularity(granularity == null ? null : ReplicationGranularity.fromString((String)granularity.toUpperCase()));
    }

    public void setReplicationTrigger(ReplicationTrigger trigger) {
        this.replicationTrigger_ = trigger;
    }

    public String getReplicationTriggerString() {
        return this.replicationTrigger_ == null ? null : this.replicationTrigger_.toString();
    }

    public void setReplicationTriggerString(String trigger) {
        this.setReplicationTrigger(trigger == null ? null : ReplicationTrigger.fromString((String)trigger.toUpperCase()));
    }

    public void setReplicationFieldBatchMode(boolean replicationFieldBatchMode) {
        this.replicationFieldBatchMode_ = replicationFieldBatchMode;
    }

    protected void initDistributedCacheManager() throws ClusteringNotSupportedException {
        this.proxy_ = this.distributedCacheManagerFactory.getDistributedCacheManager((LocalDistributableSessionManager)this);
    }

    protected void initSnapshotManager() {
        String ctxPath = ((Context)this.container_).getPath();
        if (SnapshotMode.INSTANT == this.snapshotMode_) {
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else if (this.snapshotMode_ == null) {
            this.log_.warn((Object)"Snapshot mode must be 'instant' or 'interval' - using 'instant'");
            this.snapshotMode_ = SnapshotMode.INSTANT;
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else {
            if (ReplicationGranularity.FIELD == this.replicationGranularity_) {
                throw new IllegalStateException("Property snapshotMode must be " + SnapshotMode.INTERVAL + " when FIELD granularity is used");
            }
            if (this.snapshotInterval_ < 1) {
                this.log_.warn((Object)"Snapshot mode set to 'interval' but snapshotInterval is < 1 using 'instant'");
                this.snapshotMode_ = SnapshotMode.INSTANT;
                this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
            } else {
                this.snapshotManager_ = new IntervalSnapshotManager(this, ctxPath, this.snapshotInterval_);
            }
        }
        this.snapshotManager_.start();
    }

    protected SnapshotManager getSnapshotManager() {
        return this.snapshotManager_;
    }

    protected void setSnapshotManager(SnapshotManager manager) {
        this.snapshotManager_ = manager;
    }

    protected void installValves() {
        this.log_.debug((Object)"Adding LockingValve");
        this.installValve((Valve)new LockingValve(this.valveLock));
        if (this.useJK_ == null) {
            this.useJK_ = this.getJvmRoute() != null;
        }
        if (this.getUseJK()) {
            this.log_.debug((Object)"We are using JK for load-balancing. Adding JvmRouteValve.");
            this.installValve((Valve)new JvmRouteValve(this));
        }
        BatchingManager valveBM = null;
        if (this.replicationGranularity_ == ReplicationGranularity.FIELD && Boolean.TRUE.equals(this.replicationFieldBatchMode_)) {
            valveBM = this.batchingManager;
            this.log_.debug((Object)"Including transaction manager in ClusteredSessionValve to support batch replication.");
        }
        ClusteredSessionValve valve = new ClusteredSessionValve(this, valveBM);
        this.log_.debug((Object)"Adding ClusteredSessionValve");
        this.installValve((Valve)valve);
    }

    protected void initClusteredSessionNotificationPolicy() {
        if (this.notificationPolicyClass_ == null || this.notificationPolicyClass_.length() == 0) {
            this.notificationPolicyClass_ = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jboss.web.clustered.session.notification.policy", IgnoreUndeployLegacyClusteredSessionNotificationPolicy.class.getName());
                }
            });
        }
        try {
            this.notificationPolicy_ = (ClusteredSessionNotificationPolicy)Thread.currentThread().getContextClassLoader().loadClass(this.notificationPolicyClass_).newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + ClusteredSessionNotificationPolicy.class.getName() + " " + this.notificationPolicyClass_, e);
        }
        this.notificationPolicy_.setClusteredSessionNotificationCapability(new ClusteredSessionNotificationCapability());
    }

    protected void initializeUnloadedSessions() {
        Map sessions = this.proxy_.getSessionIds();
        if (sessions != null) {
            boolean passivate = this.isPassivationEnabled();
            long passivationMax = (long)this.passivationMaxIdleTime_ * 1000L;
            long passivationMin = (long)this.passivationMinIdleTime_ * 1000L;
            for (Map.Entry entry : sessions.entrySet()) {
                String realId = (String)entry.getKey();
                String owner = (String)entry.getValue();
                long ts = -1L;
                DistributableSessionMetadata md = null;
                try {
                    IncomingDistributableSessionData sessionData = this.proxy_.getSessionData(realId, owner, false);
                    ts = sessionData.getTimestamp();
                    md = sessionData.getMetadata();
                }
                catch (Exception e) {
                    this.log_.debug((Object)("Problem reading metadata for session " + realId + " -- " + e.toString()));
                }
                long lastMod = ts == -1L ? System.currentTimeMillis() : ts;
                int maxLife = md == null ? this.getMaxInactiveInterval() : md.getMaxInactiveInterval();
                OwnedSessionUpdate osu = new OwnedSessionUpdate(owner, lastMod, maxLife, false);
                this.unloadedSessions_.put(realId, osu);
                if (!passivate) continue;
                try {
                    long elapsed = System.currentTimeMillis() - lastMod;
                    if (passivationMax >= 0L && elapsed > passivationMax) {
                        if (this.trace_) {
                            this.log_.trace((Object)("Elapsed time of " + elapsed + " for session " + realId + " exceeds max of " + passivationMax + "; passivating"));
                        }
                        this.processUnloadedSessionPassivation(realId, osu);
                        continue;
                    }
                    if (this.maxActiveAllowed_ <= 0 || passivationMin < 0L || this.calcActiveSessions() <= this.maxActiveAllowed_ || elapsed < passivationMin) continue;
                    if (this.trace_) {
                        this.log_.trace((Object)("Elapsed time of " + elapsed + " for session " + realId + " exceeds min of " + passivationMin + "; passivating"));
                    }
                    this.processUnloadedSessionPassivation(realId, osu);
                }
                catch (Exception e) {
                    this.log_.debug((Object)("Problem passivating session " + realId + " -- " + e.toString()));
                }
            }
        }
    }

    protected void startExtensions() {
    }

    protected void stopExtensions() {
    }

    @Override
    protected String getNextId() {
        String id;
        while (this.sessions_.containsKey(id = super.getNextId()) || this.unloadedSessions_.containsKey(id)) {
            this.duplicates_.incrementAndGet();
        }
        return id;
    }

    @Override
    protected int getTotalActiveSessions() {
        return this.localActiveCounter_.get() + this.unloadedSessions_.size() - this.passivatedCount_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processExpirationPassivation() {
        boolean passivate;
        block25: {
            boolean expire = this.maxInactiveInterval_ >= 0;
            passivate = this.isPassivationEnabled();
            long passivationMax = (long)this.passivationMaxIdleTime_ * 1000L;
            long passivationMin = (long)this.passivationMinIdleTime_ * 1000L;
            if (this.trace_) {
                this.log_.trace((Object)"processExpirationPassivation(): Looking for sessions that have expired ...");
                this.log_.trace((Object)("processExpirationPassivation(): active sessions = " + this.calcActiveSessions()));
                this.log_.trace((Object)("processExpirationPassivation(): expired sessions = " + this.expiredCounter_));
                if (passivate) {
                    this.log_.trace((Object)("processExpirationPassivation(): passivated count = " + this.getPassivatedSessionCount()));
                }
            }
            TreeSet<PassivationCheck> passivationChecks = new TreeSet<PassivationCheck>();
            try {
                try {
                    SessionInvalidationTracker.suspend();
                    ClusteredSession<? extends OutgoingDistributableSessionData>[] sessions = this.findLocalSessions();
                    for (int i = 0; i < sessions.length; ++i) {
                        try {
                            ClusteredSession<? extends OutgoingDistributableSessionData> session = sessions[i];
                            if (session == null) {
                                this.log_.warn((Object)("processExpirationPassivation(): processing null session at index " + i));
                                continue;
                            }
                            if (expire) {
                                if (session.isOutdated() && !session.isValid(false)) {
                                    this.loadSession(session.getRealId());
                                }
                                if (!session.isValid()) continue;
                            }
                            if (!passivate) continue;
                            passivationChecks.add(new PassivationCheck(session));
                            continue;
                        }
                        catch (Exception ex) {
                            this.log_.error((Object)("processExpirationPassivation(): failed handling " + sessions[i].getIdInternal() + " with exception: " + ex), (Throwable)ex);
                        }
                    }
                    long maxUnrep = this.maxUnreplicatedInterval_ < 0 ? 60L : (long)this.maxUnreplicatedInterval_;
                    HashMap<String, OwnedSessionUpdate> unloaded = new HashMap<String, OwnedSessionUpdate>(this.unloadedSessions_);
                    for (Map.Entry entry : unloaded.entrySet()) {
                        String realId = (String)entry.getKey();
                        OwnedSessionUpdate osu = (OwnedSessionUpdate)entry.getValue();
                        long now = System.currentTimeMillis();
                        long elapsed = now - osu.updateTime;
                        try {
                            if (expire && osu.maxInactive >= 1 && elapsed >= ((long)osu.maxInactive + maxUnrep) * 1000L) {
                                Session session;
                                if (osu.passivated && (session = this.findSession(realId)) != null) {
                                    session.isValid();
                                    continue;
                                }
                                this.proxy_.removeSessionLocal(realId, osu.owner);
                                this.unloadedSessions_.remove(realId);
                                this.stats_.removeStats(realId);
                                continue;
                            }
                            if (!passivate || osu.passivated) continue;
                            passivationChecks.add(new PassivationCheck(realId, osu));
                        }
                        catch (Exception ex) {
                            this.log_.error((Object)("processExpirationPassivation(): failed handling unloaded session " + realId), (Throwable)ex);
                        }
                    }
                    if (passivate) {
                        for (PassivationCheck passivationCheck : passivationChecks) {
                            try {
                                long timeNow = System.currentTimeMillis();
                                long timeIdle = timeNow - passivationCheck.getLastUpdate();
                                if (passivationMax >= 0L && timeIdle > passivationMax) {
                                    passivationCheck.passivate();
                                    continue;
                                }
                                if (this.maxActiveAllowed_ <= 0 || passivationMin <= 0L || this.calcActiveSessions() < this.maxActiveAllowed_ || timeIdle <= passivationMin) break;
                                passivationCheck.passivate();
                            }
                            catch (Exception e) {
                                String unloadMark = passivationCheck.isUnloaded() ? "unloaded " : "";
                                this.log_.error((Object)("processExpirationPassivation(): failed passivating " + unloadMark + "session " + passivationCheck.getRealId()), (Throwable)e);
                            }
                        }
                    }
                    Object var22_23 = null;
                }
                catch (Exception ex) {
                    this.log_.error((Object)("processExpirationPassivation(): failed with exception: " + ex), (Throwable)ex);
                    Object var22_24 = null;
                    SessionInvalidationTracker.resume();
                    break block25;
                }
            }
            catch (Throwable throwable) {
                Object var22_25 = null;
                SessionInvalidationTracker.resume();
                throw throwable;
            }
            SessionInvalidationTracker.resume();
        }
        if (this.trace_) {
            this.log_.trace((Object)"processExpirationPassivation(): Completed ...");
            this.log_.trace((Object)("processExpirationPassivation(): active sessions = " + this.calcActiveSessions()));
            this.log_.trace((Object)("processExpirationPassivation(): expired sessions = " + this.expiredCounter_));
            if (passivate) {
                this.log_.trace((Object)("processExpirationPassivation(): passivated count = " + this.getPassivatedSessionCount()));
            }
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.maxPassivatedCount_.set(this.passivatedCount_.get());
    }

    private ClusteredSession<? extends OutgoingDistributableSessionData> createEmptyClusteredSession() {
        ClusteredSession session = null;
        switch (this.replicationGranularity_) {
            case ATTRIBUTE: {
                JBossCacheManager<OutgoingAttributeGranularitySessionData> amgr = JBossCacheManager.uncheckedCastManager(this);
                session = new AttributeBasedClusteredSession((ClusteredManager<OutgoingAttributeGranularitySessionData>)amgr);
                break;
            }
            case FIELD: {
                JBossCacheManager<OutgoingDistributableSessionData> fmgr = JBossCacheManager.uncheckedCastManager(this);
                session = new FieldBasedClusteredSession((ClusteredManager<OutgoingDistributableSessionData>)fmgr);
                break;
            }
            default: {
                JBossCacheManager<OutgoingSessionGranularitySessionData> smgr = JBossCacheManager.uncheckedCastManager(this);
                session = new SessionBasedClusteredSession((ClusteredManager<OutgoingSessionGranularitySessionData>)smgr);
            }
        }
        return session;
    }

    private void add(ClusteredSession<? extends OutgoingDistributableSessionData> session, boolean replicate) {
        if (!session.isValid()) {
            this.log_.debug((Object)("Cannot add session with id=" + session.getIdInternal() + " because it is invalid"));
            return;
        }
        String realId = session.getRealId();
        ClusteredSession<? extends OutgoingDistributableSessionData> existing = this.sessions_.put(realId, session);
        this.unloadedSessions_.remove(realId);
        if (!session.equals(existing)) {
            if (replicate) {
                this.storeSession(session);
            }
            this.calcActiveSessions();
            if (this.trace_) {
                this.log_.trace((Object)("Session with id=" + session.getIdInternal() + " added. " + "Current active sessions " + this.localActiveCounter_.get()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ClusteredSession<? extends OutgoingDistributableSessionData> loadSession(String realId) {
        if (realId == null) {
            return null;
        }
        long begin = System.currentTimeMillis();
        boolean mustAdd = false;
        boolean passivated = false;
        ClusteredSession<OutgoingDistributableSessionData> session = (ClusteredSession<OutgoingDistributableSessionData>)this.sessions_.get(realId);
        boolean initialLoad = false;
        if (session == null) {
            initialLoad = true;
            mustAdd = true;
            session = this.createEmptyClusteredSession();
            OwnedSessionUpdate osu = this.unloadedSessions_.get(realId);
            passivated = osu != null && osu.passivated;
        }
        ClusteredSession<OutgoingDistributableSessionData> clusteredSession = session;
        synchronized (clusteredSession) {
            block30: {
                Object v0;
                boolean doTx;
                ContextClassLoaderSwitcher.SwitchContext switcher;
                block28: {
                    switcher = null;
                    doTx = false;
                    if (!this.batchingManager.isBatchInProgress()) {
                        this.batchingManager.startBatch();
                        doTx = true;
                    }
                    switcher = JBossCacheManager.getContextClassLoaderSwitcher().getSwitchContext();
                    switcher.setClassLoader(this.tcl_);
                    IncomingDistributableSessionData data = this.proxy_.getSessionData(realId, initialLoad);
                    if (data != null) {
                        session.update(data);
                    } else {
                        session = null;
                    }
                    if (session == null) break block28;
                    ClusteredSessionNotificationCause cause = passivated ? ClusteredSessionNotificationCause.ACTIVATION : ClusteredSessionNotificationCause.FAILOVER;
                    session.notifyDidActivate(cause);
                }
                Object var14_15 = null;
                try {
                    if (doTx) {
                        this.batchingManager.endBatch();
                    }
                    v0 = null;
                }
                catch (Throwable throwable) {
                    Object var16_19;
                    v0 = var16_19 = null;
                }
                if (switcher != null) {
                    switcher.reset();
                }
                break block30;
                {
                    catch (Exception ex) {
                        try {
                            this.batchingManager.setBatchRollbackOnly();
                        }
                        catch (Exception exn) {
                            this.log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
                        }
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        throw new RuntimeException("loadSession(): failed to load session " + realId, ex);
                    }
                }
                catch (Throwable throwable) {
                    Object v1;
                    Object var14_16 = null;
                    try {
                        if (doTx) {
                            this.batchingManager.endBatch();
                        }
                        v1 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var16_20;
                        v1 = var16_20 = null;
                    }
                    if (switcher != null) {
                        switcher.reset();
                    }
                    throw throwable;
                }
            }
            if (session != null) {
                if (mustAdd) {
                    this.add(session, false);
                    if (!passivated) {
                        session.tellNew(ClusteredSessionNotificationCause.FAILOVER);
                    }
                }
                long elapsed = System.currentTimeMillis() - begin;
                this.stats_.updateLoadStats(realId, elapsed);
                if (this.trace_) {
                    this.log_.trace((Object)("loadSession(): id= " + realId + ", session=" + session));
                }
            } else if (this.trace_) {
                this.log_.trace((Object)("loadSession(): session " + realId + " not found in distributed cache"));
            }
        }
        return session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSessionRepl(ClusteredSession<? extends OutgoingDistributableSessionData> session) {
        boolean notSession = this.replicationGranularity_ != ReplicationGranularity.SESSION;
        boolean doTx = false;
        try {
            try {
                if (notSession && !this.batchingManager.isBatchInProgress()) {
                    this.batchingManager.startBatch();
                    doTx = true;
                }
                session.processSessionReplication();
            }
            catch (Exception ex) {
                this.log_.debug((Object)"processSessionRepl(): failed with exception", (Throwable)ex);
                try {
                    if (notSession) {
                        this.batchingManager.setBatchRollbackOnly();
                    }
                }
                catch (Exception exn) {
                    this.log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
                }
                if (!(ex instanceof RuntimeException)) throw new RuntimeException("JBossCacheManager.processSessionRepl(): failed to replicate session.", ex);
                throw (RuntimeException)ex;
            }
            Object var7_4 = null;
            if (!doTx) return;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!doTx) throw throwable;
            this.batchingManager.endBatch();
            throw throwable;
        }
        this.batchingManager.endBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionPassivation(String realId) {
        ClusteredSession<? extends OutgoingDistributableSessionData> session = this.findLocalSession(realId);
        if (session != null) {
            ClusteredSession<? extends OutgoingDistributableSessionData> clusteredSession = session;
            synchronized (clusteredSession) {
                if (this.trace_) {
                    this.log_.trace((Object)("Passivating session with id: " + realId));
                }
                session.notifyWillPassivate(ClusteredSessionNotificationCause.PASSIVATION);
                this.proxy_.evictSession(realId);
                this.sessionPassivated();
                OwnedSessionUpdate obj = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(null, session.getLastAccessedTimeInternal(), session.getMaxInactiveInterval(), true));
                if (this.trace_) {
                    if (obj == null) {
                        this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
                    } else {
                        this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
                    }
                }
                this.sessions_.remove(realId);
            }
        } else if (this.trace_) {
            this.log_.trace((Object)("processSessionPassivation():  could not find session " + realId));
        }
    }

    private void processUnloadedSessionPassivation(String realId, OwnedSessionUpdate osu) {
        if (this.trace_) {
            this.log_.trace((Object)("Passivating session with id: " + realId));
        }
        this.proxy_.evictSession(realId, osu.owner);
        osu.passivated = true;
        this.sessionPassivated();
    }

    private void sessionPassivated() {
        int pc = this.passivatedCount_.incrementAndGet();
        int max = this.maxPassivatedCount_.get();
        while (pc > max) {
            if (this.maxPassivatedCount_.compareAndSet(max, pc)) continue;
            max = this.maxPassivatedCount_.get();
        }
    }

    private void startUnembedded() throws LifecycleException {
        if (this.started_) {
            return;
        }
        this.log_.info((Object)"Manager is about to start");
        this.lifecycle_.fireLifecycleEvent("before_start", (Object)this);
        if (this.snapshotMode_ == null) {
            try {
                JBossCacheCluster cluster = (JBossCacheCluster)this.container_.getCluster();
                cluster.configureManager(this);
            }
            catch (ClassCastException e) {
                String msg = "Cluster is not an instance of JBossCacheCluster";
                this.log_.error((Object)msg, (Throwable)e);
                throw new LifecycleException(msg, (Throwable)e);
            }
        }
        this.initClusteredSessionNotificationPolicy();
        try {
            if (this.replicationConfig_ == null) {
                this.synthesizeReplicationConfig();
            }
            if (this.proxy_ == null) {
                this.initDistributedCacheManager();
            }
            this.tcl_ = this.container_.getLoader().getClassLoader();
            this.proxy_.start();
        }
        catch (Throwable t) {
            String str = "Problem starting JBossCacheService for Tomcat clustering";
            this.log_.error((Object)str, t);
            throw new LifecycleException(str, t);
        }
        this.batchingManager = this.proxy_.getBatchingManager();
        if (this.batchingManager == null) {
            throw new LifecycleException("JBossCacheManager.start(): Obtain null batchingManager");
        }
        try {
            this.initializeUnloadedSessions();
            this.installValves();
            this.started_ = true;
            this.lifecycle_.fireLifecycleEvent("after_start", (Object)this);
            this.startExtensions();
            this.log_.debug((Object)"start(): JBossCacheService started");
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        this.registerManagerMBean();
    }

    private void synthesizeReplicationConfig() {
        ReplicationConfig cfg = new ReplicationConfig();
        cfg.setReplicationGranularity(this.replicationGranularity_);
        cfg.setReplicationTrigger(this.replicationTrigger_);
        cfg.setUseJK(this.useJK_);
        cfg.setCacheName(this.cacheConfigName_);
        cfg.setSnapshotMode(this.snapshotMode_);
        cfg.setSnapshotInterval(Integer.valueOf(this.snapshotInterval_));
        cfg.setMaxUnreplicatedInterval(Integer.valueOf(this.maxUnreplicatedInterval_));
        cfg.setSessionNotificationPolicy(this.notificationPolicyClass_);
        this.replicationConfig_ = cfg;
    }

    private void installValve(Valve valve) {
        ObjectName name;
        boolean installed = false;
        if (this.embedded_ && (name = this.getObjectName(this.container_)) != null) {
            try {
                MBeanServer server = this.getMBeanServer();
                server.invoke(name, "addValve", new Object[]{valve}, new String[]{Valve.class.getName()});
                installed = true;
            }
            catch (Exception e) {
                this.log_.debug((Object)"Caught exception installing valve to Context", (Throwable)e);
            }
        }
        if (!installed) {
            if (this.container_ instanceof ContainerBase) {
                ((ContainerBase)this.container_).addValve(valve);
            } else {
                this.container_.getPipeline().addValve(valve);
            }
        }
    }

    private ObjectName getObjectName(Container container) {
        String oname = container.getObjectName();
        try {
            return oname == null ? null : new ObjectName(oname);
        }
        catch (MalformedObjectNameException e) {
            this.log_.warn((Object)("Error creating object name from string " + oname), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSessions() {
        boolean passivation = this.isPassivationEnabled();
        ClusteredSession<? extends OutgoingDistributableSessionData>[] sessions = this.findLocalSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object var9_13;
            ClusteredSession<? extends OutgoingDistributableSessionData> ses = sessions[i];
            if (this.trace_) {
                this.log_.trace((Object)("clearSessions(): clear session by expiring or passivating: " + ses));
            }
            try {
                block13: {
                    try {
                        if (passivation && ses.isValid()) {
                            this.processSessionPassivation(ses.getRealId());
                            break block13;
                        }
                        boolean notify = true;
                        boolean localCall = true;
                        boolean localOnly = true;
                        ses.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.UNDEPLOY);
                    }
                    catch (Throwable t) {
                        this.log_.warn((Object)("clearSessions(): Caught exception expiring or passivating session " + ses.getIdInternal()), t);
                        var9_13 = null;
                        ses.recycle();
                        continue;
                    }
                }
                var9_13 = null;
                ses.recycle();
                continue;
            }
            catch (Throwable throwable) {
                var9_13 = null;
                ses.recycle();
                throw throwable;
            }
        }
        String action = passivation ? "evicting" : "removing";
        Set<Map.Entry<String, OwnedSessionUpdate>> unloaded = this.unloadedSessions_.entrySet();
        Iterator<Map.Entry<String, OwnedSessionUpdate>> it = unloaded.iterator();
        while (it.hasNext()) {
            Map.Entry<String, OwnedSessionUpdate> entry = it.next();
            String realId = entry.getKey();
            try {
                if (passivation) {
                    OwnedSessionUpdate osu = entry.getValue();
                    if (!osu.passivated) {
                        this.proxy_.evictSession(realId, osu.owner);
                    }
                } else {
                    this.proxy_.removeSessionLocal(realId);
                }
            }
            catch (Exception e) {
                this.log_.debug((Object)("Problem " + action + " session " + realId + " -- " + e));
            }
            it.remove();
        }
    }

    private void startEmbedded() throws LifecycleException {
        super.start();
        this.initClusteredSessionNotificationPolicy();
        this.tcl_ = super.getContainer().getLoader().getClassLoader();
        try {
            if (this.proxy_ == null) {
                this.initDistributedCacheManager();
            }
            this.proxy_.start();
            this.batchingManager = this.proxy_.getBatchingManager();
            if (this.batchingManager == null) {
                throw new LifecycleException("JBossCacheManager.start(): Obtain null batchingManager");
            }
            this.initializeUnloadedSessions();
            this.initSnapshotManager();
            this.installValves();
            this.startExtensions();
            this.log_.debug((Object)"start(): JBossCacheService started");
        }
        catch (LifecycleException le) {
            throw le;
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
    }

    private String getRealId(String id) {
        return this.getUseJK() ? Util.getRealId(id) : id;
    }

    private String reportSessionIds(Set<String> ids) {
        StringBuffer sb = new StringBuffer();
        boolean added = false;
        for (String id : ids) {
            if (added) {
                sb.append(',');
            } else {
                added = true;
            }
            sb.append(id);
        }
        return sb.toString();
    }

    private static ContextClassLoaderSwitcher getContextClassLoaderSwitcher() {
        return (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    }

    private static <T extends OutgoingDistributableSessionData> JBossCacheManager<T> uncheckedCastManager(JBossCacheManager mgr) {
        return mgr;
    }

    private static ClusteredSession<? extends OutgoingDistributableSessionData> uncheckedCastSession(Session session) {
        return (ClusteredSession)session;
    }

    private static class SemaphoreLock
    implements Lock {
        private final Semaphore semaphore;

        SemaphoreLock(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        public void lock() {
            this.semaphore.acquireUninterruptibly();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.semaphore.acquire();
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock() {
            return this.semaphore.tryAcquire();
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(timeout, unit);
        }

        public void unlock() {
            this.semaphore.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PassivationCheck
    implements Comparable<PassivationCheck> {
        private final String realId;
        private final OwnedSessionUpdate osu;
        private final ClusteredSession<? extends OutgoingDistributableSessionData> session;

        private PassivationCheck(String realId, OwnedSessionUpdate osu) {
            assert (osu != null) : "osu is null";
            assert (realId != null) : "realId is null";
            this.realId = realId;
            this.osu = osu;
            this.session = null;
        }

        private PassivationCheck(ClusteredSession<? extends OutgoingDistributableSessionData> session) {
            assert (session != null) : "session is null";
            this.realId = session.getRealId();
            this.session = session;
            this.osu = null;
        }

        private long getLastUpdate() {
            return this.osu == null ? this.session.getLastAccessedTimeInternal() : this.osu.updateTime;
        }

        private void passivate() {
            if (this.osu == null) {
                JBossCacheManager.this.processSessionPassivation(this.realId);
            } else {
                JBossCacheManager.this.processUnloadedSessionPassivation(this.realId, this.osu);
            }
        }

        private String getRealId() {
            return this.realId;
        }

        private boolean isUnloaded() {
            return this.osu != null;
        }

        @Override
        public int compareTo(PassivationCheck o) {
            long anotherVal;
            long thisVal = this.getLastUpdate();
            return thisVal < (anotherVal = o.getLastUpdate()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }

    private class OwnedSessionUpdate {
        String owner;
        long updateTime;
        int maxInactive;
        boolean passivated;

        OwnedSessionUpdate(String owner, long updateTime, int maxInactive, boolean passivated) {
            this.owner = owner;
            this.updateTime = updateTime;
            this.maxInactive = maxInactive;
            this.passivated = passivated;
        }
    }
}

