/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExoContainerContext
implements Serializable {
    private static ThreadLocal<ExoContainer> currentContainer = new ThreadLocal();
    private static volatile ExoContainer topContainer;
    private HashMap<String, Object> attributes = new HashMap();
    private ExoContainer container;
    private String name;
    private static final Log log;

    public ExoContainerContext(ExoContainer container) {
        this.container = container;
    }

    public ExoContainer getContainer() {
        return this.container;
    }

    public String getPortalContainerName() {
        if (this.container instanceof PortalContainer) {
            return ((PortalContainer)this.container).getName();
        }
        return null;
    }

    public String getRestContextName() {
        if (this.container instanceof PortalContainer) {
            return ((PortalContainer)this.container).getRestContextName();
        }
        return PortalContainer.DEFAULT_REST_CONTEXT_NAME;
    }

    public String getRealmName() {
        if (this.container instanceof PortalContainer) {
            return ((PortalContainer)this.container).getRealmName();
        }
        return PortalContainer.DEFAULT_REALM_NAME;
    }

    public Object getSetting(String settingName) {
        if (this.container instanceof PortalContainer) {
            return ((PortalContainer)this.container).getSetting(settingName);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ExoContainer getTopContainer() {
        if (topContainer == null) {
            topContainer = RootContainer.getInstance();
        }
        return topContainer;
    }

    static void setTopContainer(ExoContainer cont) {
        if (topContainer != null && cont != null) {
            throw new IllegalStateException("Two top level containers created, but must be only one.");
        }
        log.info((Object)"Set the top container in its context");
        topContainer = cont;
    }

    public static ExoContainer getCurrentContainer() {
        ExoContainer container = currentContainer.get();
        if (container == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }

    public static ExoContainer getCurrentContainerIfPresent() {
        ExoContainer container = currentContainer.get();
        if (container == null) {
            return topContainer;
        }
        return container;
    }

    public static void setCurrentContainer(ExoContainer instance) {
        currentContainer.set(instance);
    }

    public static ExoContainer getContainerByName(String name) {
        ExoContainerContext containerContext = topContainer.getContext();
        String name1 = containerContext.getName();
        if (name1.equals(name)) {
            return topContainer;
        }
        return (ExoContainer)((Object)topContainer.getComponentInstance(name));
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    static {
        log = ExoLogger.getLogger(ExoContainerContext.class);
    }
}

