/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.mxbean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.mxbean.MXBeanMetaData;
import org.jboss.mx.mxbean.MXBeanUtils;
import org.jboss.mx.server.ExceptionHandler;

public class MXBeanDelegate
extends NotificationBroadcasterSupport
implements DynamicMBean,
MBeanRegistration,
NotificationEmitter {
    private static final Logger log = Logger.getLogger(MXBeanDelegate.class);
    private Object implementation;
    private Class mbeanInterface;
    private OpenMBeanInfo cachedMBeanInfo;
    private Map<String, OpenMBeanAttributeInfo> attributeMapping;
    private Map<String, Method> getters;
    private Map<String, Method> setters;
    private Map<String, Method> operations;

    public MXBeanDelegate(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        this.implementation = implementation;
        this.mbeanInterface = mbeanInterface;
    }

    protected MXBeanDelegate(Class mbeanInterface) throws NotCompliantMBeanException {
        this.implementation = this;
        this.mbeanInterface = mbeanInterface;
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("Null implementation");
        }
        this.implementation = implementation;
    }

    public Class getImplementationClass() {
        return this.implementation.getClass();
    }

    public final Class getMBeanInterface() {
        return this.mbeanInterface;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            OpenMBeanAttributeInfo attributeInfo = this.attributeMapping.get(attribute);
            if (attributeInfo == null) {
                throw new AttributeNotFoundException(attribute);
            }
            MBeanAttributeInfo mbeanAttributeInfo = (MBeanAttributeInfo)((Object)attributeInfo);
            if (!mbeanAttributeInfo.isReadable()) {
                throw new AttributeNotFoundException("Attribute is not readable: " + attribute);
            }
            Method method = this.getters.get(attribute);
            if (method == null) {
                throw new NoSuchMethodException("No method to get attribute: " + attribute);
            }
            Object result = method.invoke(this.implementation, new Object[0]);
            return MXBeanUtils.construct(attributeInfo.getOpenType(), result, (Object)("Get attribute: " + attribute));
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException((Throwable)e);
            if (result instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)result;
            }
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot get attribute: " + attribute);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            String attributeName = attribute.getName();
            OpenMBeanAttributeInfo attributeInfo = this.attributeMapping.get(attributeName);
            if (attributeInfo == null) {
                throw new AttributeNotFoundException(attributeName);
            }
            MBeanAttributeInfo mbeanAttributeInfo = (MBeanAttributeInfo)((Object)attributeInfo);
            if (!mbeanAttributeInfo.isWritable()) {
                throw new AttributeNotFoundException("Attribute is not writable: " + attributeName);
            }
            Method method = this.setters.get(attributeName);
            if (method == null) {
                throw new NoSuchMethodException("No method to set attribute: " + attribute);
            }
            Object value = MXBeanUtils.reconstruct(method.getGenericParameterTypes()[0], attribute.getValue(), method);
            method.invoke(this.implementation, value);
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException((Throwable)e);
            if (result instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)result;
            }
            if (result instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)result;
            }
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot set attribute: " + attribute);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        try {
            AttributeList attrList = new AttributeList(attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                String name = attributes[i];
                Object value = this.getAttribute(name);
                attrList.add(new Attribute(name, value));
            }
            return attrList;
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException((Throwable)e);
            throw new RuntimeException("Cannot get attributes", result);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList(attributes.size());
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            String name = attr.getName();
            try {
                this.setAttribute(attr);
                result.add(new Attribute(name, attr.getValue()));
                continue;
            }
            catch (Throwable t) {
                JMException e = ExceptionHandler.handleException((Throwable)t);
                result.add(new Attribute(name, e));
            }
        }
        return result;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            Object result;
            String signatureString = this.getSignatureString(actionName, signature);
            Method method = this.operations.get(signatureString);
            if (method == null) {
                throw new NoSuchMethodException("Cannot find method for operation: " + signatureString);
            }
            Object[] parameters = params;
            if (params.length > 0) {
                parameters = new Object[params.length];
                Type[] parameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = MXBeanUtils.reconstruct(parameterTypes[i], params[i], method);
                }
            }
            if ((result = method.invoke(this.implementation, parameters)) == null) {
                return null;
            }
            Type returnType = method.getGenericReturnType();
            return MXBeanUtils.construct(returnType, result, (Object)method);
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException((Throwable)e);
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot invoke: " + actionName);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public MBeanInfo getMBeanInfo() {
        OpenMBeanInfo info = this.getCachedMBeanInfo();
        if (info == null) {
            try {
                info = this.buildMBeanInfo();
                this.cacheMBeanInfo(info);
            }
            catch (NotCompliantMBeanException e) {
                log.error((Object)"Unexcepted exception", (Throwable)e);
                throw new IllegalStateException("Unexcepted exception " + e.toString());
            }
        }
        return (MBeanInfo)((Object)info);
    }

    public OpenMBeanInfo getCachedMBeanInfo() {
        return this.cachedMBeanInfo;
    }

    public void cacheMBeanInfo(OpenMBeanInfo info) {
        this.cachedMBeanInfo = info;
        HashMap<String, OpenMBeanAttributeInfo> attributeMapping = new HashMap<String, OpenMBeanAttributeInfo>();
        MBeanAttributeInfo[] attributes = info.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            OpenMBeanAttributeInfo attribute = (OpenMBeanAttributeInfo)((Object)attributes[i]);
            attributeMapping.put(attribute.getName(), attribute);
        }
        this.attributeMapping = attributeMapping;
        try {
            Method[] methods;
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            HashMap<String, Method> operations = new HashMap<String, Method>();
            for (Method method : methods = this.implementation.getClass().getMethods()) {
                Method getter;
                String key;
                String methodName = method.getName();
                Type[] signature = method.getGenericParameterTypes();
                Type returnType = method.getGenericReturnType();
                if (methodName.startsWith("set") && methodName.length() > 3 && signature.length == 1 && returnType == Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    Method setter = setters.get(key);
                    if (setter != null && !setter.getGenericParameterTypes()[0].equals(signature[0])) {
                        throw new RuntimeException("overloaded type for attribute set: " + key);
                    }
                    setters.put(key, method);
                    continue;
                }
                if (methodName.startsWith("get") && methodName.length() > 3 && signature.length == 0 && returnType != Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    getter = getters.get(key);
                    if (getter != null && getter.getName().startsWith("is")) {
                        throw new RuntimeException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, method);
                    continue;
                }
                if (methodName.startsWith("is") && methodName.length() > 2 && signature.length == 0 && returnType == Boolean.TYPE) {
                    key = methodName.substring(2, methodName.length());
                    getter = getters.get(key);
                    if (getter != null && getter.getName().startsWith("get")) {
                        throw new RuntimeException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, method);
                    continue;
                }
                operations.put(this.getSignatureString(method), method);
            }
            this.getters = getters;
            this.setters = setters;
            this.operations = operations;
        }
        catch (RuntimeException e) {
            log.error((Object)"Error: ", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)"Error: ", (Throwable)e);
            throw e;
        }
    }

    public OpenMBeanInfo buildMBeanInfo() throws NotCompliantMBeanException {
        if (this.implementation == null) {
            throw new IllegalArgumentException("Null implementation");
        }
        MXBeanMetaData metadata = new MXBeanMetaData(this.implementation, this.mbeanInterface);
        return (OpenMBeanInfo)((Object)metadata.build());
    }

    private String getSignatureString(Method method) {
        String name = method.getName();
        Class<?>[] signature = method.getParameterTypes();
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(name);
        buffer.append("(");
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                buffer.append(signature[i].getName());
                if (i >= signature.length - 1) continue;
                buffer.append(",");
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String getSignatureString(String operation, String[] signature) {
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(operation);
        buffer.append("(");
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                buffer.append(signature[i]);
                if (i >= signature.length - 1) continue;
                buffer.append(",");
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

