/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileDigestOutputStream;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CASableIOSupport {
    private static Log LOG = ExoLogger.getLogger((String)"jcr.CASeableIOSupport");
    public static final int HASHFILE_ORDERNUMBER = 0;
    protected final FileIOChannel channel;
    protected final String digestAlgo;

    CASableIOSupport(FileIOChannel channel, String digestAlgo) {
        this.channel = channel;
        this.digestAlgo = digestAlgo;
    }

    public FileDigestOutputStream openFile(File file) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(this.digestAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)("Can't wriet using " + this.digestAlgo + " algorithm, " + e), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        return new FileDigestOutputStream(file, md);
    }

    public File getFile(String hash) {
        return new File(this.channel.rootDir, this.channel.makeFilePath(hash, 0));
    }
}

