/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SpoolFile
extends File {
    private static Log log = ExoLogger.getLogger((String)"jcr.SpoolFile");
    protected Map<Object, Long> users = new WeakHashMap<Object, Long>();

    public SpoolFile(File parent, String child) {
        super(parent, child);
    }

    public SpoolFile(String absPath) {
        super(absPath);
    }

    public static SpoolFile createTempFile(String prefix, String suffix, File directory) throws IOException {
        return new SpoolFile(File.createTempFile(prefix, suffix, directory).getAbsolutePath());
    }

    public synchronized void acquire(Object holder) throws FileNotFoundException {
        if (this.users == null) {
            throw new FileNotFoundException("File was deleted " + this.getAbsolutePath());
        }
        this.users.put(holder, System.currentTimeMillis());
    }

    public synchronized void release(Object holder) throws FileNotFoundException {
        if (this.users == null) {
            throw new FileNotFoundException("File was deleted " + this.getAbsolutePath());
        }
        this.users.remove(holder);
    }

    public synchronized boolean inUse() throws FileNotFoundException {
        if (this.users == null) {
            throw new FileNotFoundException("File was deleted " + this.getAbsolutePath());
        }
        return this.users.size() > 0;
    }

    public synchronized boolean delete() {
        if (this.users != null && this.users.size() <= 0) {
            this.users.clear();
            this.users = null;
            return super.delete();
        }
        return false;
    }
}

