/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;

public class PackageDetailsKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String version;
    private final String packageTypeName;
    private final String architectureName;

    public PackageDetailsKey(String name, String version, String packageTypeName, String architectureName) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or zero length");
        }
        if (version == null || version.length() == 0) {
            throw new IllegalArgumentException("version cannot be null or zero length");
        }
        if (packageTypeName == null || packageTypeName.length() == 0) {
            throw new IllegalArgumentException("packageTypeName cannot be null or zero length");
        }
        if (architectureName == null || architectureName.length() == 0) {
            throw new IllegalArgumentException("architectureName cannot be null or zero length");
        }
        this.name = name;
        this.version = version;
        this.packageTypeName = packageTypeName;
        this.architectureName = architectureName;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackageTypeName() {
        return this.packageTypeName;
    }

    public String getArchitectureName() {
        return this.architectureName;
    }

    public String toString() {
        return "PackageDetailsKey[Name=" + this.name + ", Version=" + this.version + " Arch=" + this.architectureName + " Type=" + this.packageTypeName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.packageTypeName.hashCode();
        result = 31 * result + this.architectureName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDetailsKey)) {
            return false;
        }
        PackageDetailsKey other = (PackageDetailsKey)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.version.equals(other.version)) {
            return false;
        }
        if (!this.packageTypeName.equals(other.packageTypeName)) {
            return false;
        }
        return this.architectureName.equals(other.architectureName);
    }
}

