/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UIOrderingBaseComponent;
import org.richfaces.component.UIOrderingList;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.OrderingComponentControlsHelper;
import org.richfaces.renderkit.OrderingComponentRendererBase;
import org.richfaces.renderkit.TableHolder;

public abstract class OrderingListRendererBase
extends OrderingComponentRendererBase {
    private static final String SELECTION_STATE_VAR_NAME = "selectionState";
    private static final String MESSAGE_BUNDLE_NAME = OrderingListRendererBase.class.getPackage().getName() + ".orderingList";
    private static final Character ACTIVITY_MARKER = new Character('a');
    private static final Character SELECTION_MARKER = new Character('s');
    private static final String ITEM_SEPARATOR = ",";
    protected static final OrderingComponentRendererBase.ControlsHelper[] HELPERS = OrderingComponentControlsHelper.HELPERS;

    public OrderingListRendererBase() {
        super(MESSAGE_BUNDLE_NAME);
    }

    protected Class getComponentClass() {
        return UIOrderingList.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        variables.setVariable(SELECTION_STATE_VAR_NAME, (Object)new OrderingComponentRendererBase.SelectionState());
        super.encodeBegin(context, component);
    }

    public boolean isHeaderExists(FacesContext context, UIOrderingBaseComponent component) {
        return this.isHeaderExists(context, component, "header");
    }

    public void encodeControlsFacets(FacesContext context, UIOrderingList orderingList) throws IOException {
        String clientId = orderingList.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        int divider = HELPERS.length / 2;
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)orderingList);
        OrderingComponentRendererBase.SelectionState selectionState = (OrderingComponentRendererBase.SelectionState)variables.getVariable(SELECTION_STATE_VAR_NAME);
        for (int i = 0; i < HELPERS.length; ++i) {
            boolean enabled;
            boolean boundarySelection = i < divider ? selectionState.isFirstSelected() : selectionState.isLastSelected();
            boolean bl = enabled = selectionState.isSelected() && !boundarySelection;
            if (i % 2 == 1) {
                boolean bl2 = enabled = !enabled;
            }
            if (!HELPERS[i].isRendered(context, orderingList)) continue;
            this.encodeControlFacet(context, orderingList, HELPERS[i], clientId, writer, enabled, "rich-ordering-list-button", " rich-ordering-control");
        }
    }

    public void encodeRows(FacesContext context, UIComponent component) throws IOException {
        UIOrderingBaseComponent orderingBaseComponent = (UIOrderingBaseComponent)component;
        super.encodeRows(context, component, new OrderingListRendererTableHolder(orderingBaseComponent, this.getConverter(context, orderingBaseComponent, true)));
    }

    public void encodeOneRow(FacesContext context, TableHolder holder) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OrderingListRendererTableHolder tableHolder = (OrderingListRendererTableHolder)holder;
        UIOrderingList table = (UIOrderingList)holder.getTable();
        String clientId = holder.getTable().getClientId(context);
        writer.startElement("tr", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, null);
        StringBuffer rowClassName = new StringBuffer("rich-ordering-list-row");
        String rowClass = holder.getRowClass();
        if (rowClass != null) {
            rowClassName.append(' ');
            rowClassName.append(rowClass);
        }
        StringBuffer cellClassName = new StringBuffer("rich-ordering-list-cell");
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)table);
        UIOrderingBaseComponent.ItemState state = this.getItemState(context, (UIComponent)table, variables);
        boolean active = state.isActive();
        boolean selected = state.isSelected();
        if (selected) {
            rowClassName.append(" rich-ordering-list-row-selected");
            cellClassName.append(" rich-ordering-list-cell-selected");
        }
        OrderingComponentRendererBase.SelectionState selectionState = (OrderingComponentRendererBase.SelectionState)variables.getVariable(SELECTION_STATE_VAR_NAME);
        selectionState.addState(selected);
        writer.writeAttribute("class", (Object)rowClassName.toString(), null);
        boolean columnRendered = false;
        int colCounter = 0;
        Iterator iterator = table.columns();
        while (iterator.hasNext()) {
            UIComponent component = (UIComponent)iterator.next();
            if (component.isRendered()) {
                String columnClass;
                writer.startElement("td", (UIComponent)table);
                Object width = component.getAttributes().get("width");
                if (width != null) {
                    writer.writeAttribute("style", (Object)("width: " + HtmlUtil.qualifySize((String)width.toString())), null);
                }
                if ((columnClass = holder.getColumnClass(colCounter)) != null) {
                    writer.writeAttribute("class", (Object)cellClassName.toString().concat(" " + columnClass), null);
                } else {
                    writer.writeAttribute("class", (Object)cellClassName.toString(), null);
                }
                writer.startElement("img", (UIComponent)table);
                writer.writeAttribute("src", (Object)this.getResource("/org/richfaces/renderkit/html/images/spacer.gif").getUri(context, null), null);
                writer.writeAttribute("style", (Object)"width:1px;height:1px;", null);
                writer.writeAttribute("alt", (Object)" ", null);
                writer.endElement("img");
                this.renderChildren(context, component);
                if (!columnRendered) {
                    writer.startElement("input", (UIComponent)table);
                    writer.writeAttribute("id", (Object)(clientId + "StateInput"), null);
                    writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
                    writer.writeAttribute("name", (Object)table.getBaseClientId(context), null);
                    StringBuffer value = new StringBuffer();
                    if (selected) {
                        value.append('s');
                    }
                    if (active) {
                        value.append('a');
                    }
                    value.append(table.getRowKey());
                    value.append(':');
                    value.append(tableHolder.getConverter().getAsString(context, (UIComponent)table, table.getRowData()));
                    writer.writeAttribute("value", (Object)value.toString(), null);
                    writer.endElement("input");
                    columnRendered = true;
                }
                writer.endElement("td");
            }
            ++colCounter;
        }
        writer.endElement("tr");
    }

    public void doDecode(FacesContext context, UIComponent component) {
        UIOrderingList orderingList = (UIOrderingList)component;
        String clientId = orderingList.getBaseClientId(context);
        ExternalContext externalContext = context.getExternalContext();
        Map requestParameterValuesMap = externalContext.getRequestParameterValuesMap();
        String[] strings = (String[])requestParameterValuesMap.get(clientId);
        if (strings != null && strings.length != 0) {
            HashSet<Object> selection = new HashSet<Object>();
            Object activeItem = null;
            LinkedHashMap<Integer, Object> map = new LinkedHashMap<Integer, Object>();
            Converter converter = this.getConverter(context, orderingList, false);
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                int idx = string.indexOf(58);
                Object value = converter.getAsObject(context, (UIComponent)orderingList, string.substring(idx + 1));
                String substring = string.substring(0, idx);
                if (substring.charAt(idx = 0) == 's') {
                    selection.add(value);
                    ++idx;
                }
                if (substring.charAt(idx) == 'a') {
                    activeItem = value;
                    ++idx;
                }
                substring = substring.substring(idx);
                Integer key = new Integer(substring);
                map.put(key, value);
            }
            orderingList.setSubmittedString(map, selection, activeItem);
        }
    }

    private static final class OrderingListRendererTableHolder
    extends TableHolder {
        private Converter converter;

        public OrderingListRendererTableHolder(UIDataAdaptor table, Converter converter) {
            super(table);
            this.converter = converter;
        }

        public Converter getConverter() {
            return this.converter;
        }
    }
}

