/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.dependency.ContainerDependencyMetaData;
import org.jboss.ejb.Ejb2xMCContainer;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.deployers.EjbDeployerMBean;
import org.jboss.ejb.deployers.EjbDeployment;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaData;
import org.jboss.metadata.ejb.jboss.InvokerProxyBindingMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.verifier.BeanVerifier;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.event.VerificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMX(name="jboss.ejb:service=EJBDeployer", exposedInterface=EjbDeployerMBean.class)
public class EjbDeployer
extends AbstractSimpleVFSRealDeployer<JBossMetaData>
implements EjbDeployerMBean {
    private String transactionManagerServiceName;
    private String webServiceName;
    private String ccmServiceName;
    private String timerServiceName;
    private boolean callByValue;
    private String unauthenticatedIdentity = null;
    private String securityManagementName;
    private String securityContextClassName;
    private String defaultSecurityDomain;
    private boolean verifyDeployments;
    private boolean verifierVerbose;
    private boolean strictVerifier;
    private String policyRegistrationName;

    public EjbDeployer() {
        super(JBossMetaData.class);
        this.setOutput(ServiceMetaData.class);
        this.setOutput(EjbDeployment.class);
        this.setOutput(KernelDeployment.class);
    }

    @Override
    public String getTransactionManagerServiceName() {
        return this.transactionManagerServiceName;
    }

    @Override
    public void setTransactionManagerServiceName(String transactionManagerServiceName) {
        this.transactionManagerServiceName = transactionManagerServiceName;
    }

    @Override
    public String getWebServiceName() {
        return this.webServiceName;
    }

    @Override
    public void setWebServiceName(String webServiceName) {
        this.webServiceName = webServiceName;
    }

    public String getCachedConnectionManagerName() {
        return this.ccmServiceName;
    }

    public void setCachedConnectionManagerName(String ccmServiceName) {
        this.ccmServiceName = ccmServiceName;
    }

    public String getTimerService() {
        return this.timerServiceName;
    }

    public void setTimerServiceName(String timerServiceName) {
        this.timerServiceName = timerServiceName;
    }

    @Override
    public boolean isCallByValue() {
        return this.callByValue;
    }

    @Override
    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    public String getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    public void setUnauthenticatedIdentity(String unauthenticatedIdentity) {
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    public void setSecurityManagementName(String sm) {
        this.securityManagementName = sm;
    }

    public void setSecurityContextClassName(String securityContextClassName) {
        this.securityContextClassName = securityContextClassName;
    }

    public String getPolicyRegistration() {
        return this.policyRegistrationName;
    }

    public void setPolicyRegistrationName(String policyRegistration) {
        this.policyRegistrationName = policyRegistration;
    }

    public void deploy(VFSDeploymentUnit unit, JBossMetaData deployment) throws DeploymentException {
        if (!deployment.isEJB2x() && !deployment.isEJB1x()) {
            return;
        }
        ApplicationMetaData legacyMD = new ApplicationMetaData(deployment);
        if (this.verifyDeployments) {
            boolean allOK = true;
            try {
                BeanVerifier verifier = new BeanVerifier();
                verifier.addVerificationListener(new VerificationListener(){
                    Logger verifierLog = Logger.getLogger(EjbDeployer.class, (String)"verifier");

                    public void beanChecked(VerificationEvent event) {
                        this.verifierLog.debug((Object)("Bean checked: " + event.getMessage()));
                    }

                    public void specViolation(VerificationEvent event) {
                        this.verifierLog.warn((Object)("EJB spec violation: " + (EjbDeployer.this.verifierVerbose ? event.getVerbose() : event.getMessage())));
                    }
                });
                this.log.debug((Object)("Verifying " + unit.getRoot().toURL()));
                verifier.verify(unit.getRoot().toURL(), legacyMD, unit.getClassLoader());
                allOK = verifier.getSuccess();
            }
            catch (Throwable t) {
                this.log.warn((Object)"Verify failed; continuing", t);
                allOK = false;
            }
            if (this.strictVerifier && !allOK) {
                throw new DeploymentException("Verification of Enterprise Beans failed, see above for error messages.");
            }
        }
        ServiceMetaData ejbModule = new ServiceMetaData();
        ejbModule.setCode(EjbModule.class.getName());
        ObjectName moduleObjectName = null;
        try {
            moduleObjectName = this.getObjectName(unit, deployment);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Failed to create EJB module " + unit.getName() + ": malformed EjbModule name", (Throwable)e);
        }
        ejbModule.setObjectName(moduleObjectName);
        ServiceConstructorMetaData ctor = new ServiceConstructorMetaData();
        ctor.setSignature(new String[]{VFSDeploymentUnit.class.getName(), ApplicationMetaData.class.getName()});
        ctor.setParameters(new Object[]{unit, legacyMD});
        ejbModule.setConstructor(ctor);
        ArrayList<ServiceAttributeMetaData> attrs = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attr = new ServiceAttributeMetaData();
        attr.setName("TransactionManagerFactory");
        ServiceDependencyValueMetaData dependencyValue = new ServiceDependencyValueMetaData();
        dependencyValue.setDependency(this.getTransactionManagerServiceName());
        dependencyValue.setProxyType("attribute");
        attr.setValue((ServiceValueMetaData)dependencyValue);
        attrs.add(attr);
        attr = new ServiceAttributeMetaData();
        attr.setName("SecurityManagement");
        ServiceInjectionValueMetaData injectionValue = new ServiceInjectionValueMetaData((Object)this.securityManagementName);
        attr.setValue((ServiceValueMetaData)injectionValue);
        attrs.add(attr);
        attr = new ServiceAttributeMetaData();
        attr.setName("PolicyRegistration");
        ServiceInjectionValueMetaData prInjectionValue = new ServiceInjectionValueMetaData((Object)this.policyRegistrationName);
        attr.setValue((ServiceValueMetaData)prInjectionValue);
        attrs.add(attr);
        String wsName = this.getWebServiceName();
        if (wsName != null) {
            ServiceAttributeMetaData ws = new ServiceAttributeMetaData();
            ws.setName("WebServiceName");
            ServiceDependencyValueMetaData wsDepends = new ServiceDependencyValueMetaData();
            wsDepends.setDependency(wsName);
            ws.setValue((ServiceValueMetaData)wsDepends);
            attrs.add(ws);
        }
        ServiceAttributeMetaData tms = new ServiceAttributeMetaData();
        ServiceDependencyValueMetaData tmsDepends = new ServiceDependencyValueMetaData();
        tms.setName("TimerService");
        tmsDepends.setDependency(this.timerServiceName);
        tmsDepends.setProxyType("attribute");
        tms.setValue((ServiceValueMetaData)tmsDepends);
        attrs.add(tms);
        ejbModule.setAttributes(attrs);
        ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
        if (this.ccmServiceName != null && this.ccmServiceName.length() > 0) {
            ServiceDependencyMetaData ccm = new ServiceDependencyMetaData();
            ccm.setIDependOn(this.ccmServiceName);
            dependencies.add(ccm);
        }
        JBossEnterpriseBeansMetaData beans = deployment.getEnterpriseBeans();
        Iterator beansIter = beans.iterator();
        HashSet<String> invokerNames = new HashSet<String>();
        HashSet beanDepends = new HashSet();
        VFSDeploymentUnit topUnit = unit.getTopLevel();
        Map endpoints = (Map)topUnit.getAttachment("MappedReferenceMetaDataResolverDeployer.endpointMap");
        if (endpoints == null) {
            this.log.warn((Object)(unit + " has no ContainerDependencyMetaData attachment"));
        }
        String vfsPath = unit.getRelativePath();
        ArrayList<BeanMetaData> mcBeanMD = new ArrayList<BeanMetaData>();
        while (beansIter.hasNext()) {
            String ejbKey;
            ContainerDependencyMetaData cdmd;
            JBossEnterpriseBeanMetaData bmd = (JBossEnterpriseBeanMetaData)beansIter.next();
            Set depends = bmd.getDepends();
            if (depends != null) {
                beanDepends.addAll(depends);
            }
            String configName = bmd.getConfigurationName();
            ContainerConfigurationMetaData cmd = bmd.determineContainerConfiguration();
            Set invokers = cmd.getInvokerProxyBindingNames();
            if (invokers != null) {
                for (String iname : invokers) {
                    InvokerProxyBindingMetaData imd = deployment.getInvokerProxyBinding(iname);
                    if (imd == null) {
                        throw new DeploymentException("Failed to locate invoker: " + iname);
                    }
                    String invokerName = imd.getInvokerMBean();
                    if (invokerName.equalsIgnoreCase("default") || invokerNames.contains(invokerName)) continue;
                    invokerNames.add(invokerName);
                    ServiceDependencyMetaData invoker = new ServiceDependencyMetaData();
                    invoker.setIDependOn(invokerName);
                    dependencies.add(invoker);
                }
            }
            if (endpoints == null || (cdmd = (ContainerDependencyMetaData)((Object)endpoints.get(ejbKey = "ejb/" + vfsPath + "#" + bmd.getEjbName()))) == null) continue;
            String mcname = ejbKey + ",uid" + System.identityHashCode(bmd);
            BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)mcname, (String)Ejb2xMCContainer.class.getName());
            for (String jndiName : cdmd.getJndiNames()) {
                String supplyName = "jndi:" + jndiName;
                builder.addSupply((Object)supplyName);
            }
            BeanMetaData mcbmd = builder.getBeanMetaData();
            this.log.info((Object)("installing bean: " + mcname));
            this.log.info((Object)"  with dependencies:");
            this.log.info((Object)"  and supplies:");
            for (SupplyMetaData smd : mcbmd.getSupplies()) {
                this.log.info((Object)("\t" + smd.getSupply()));
            }
            mcBeanMD.add(mcbmd);
        }
        try {
            for (String depend : beanDepends) {
                ObjectName n = new ObjectName(depend);
                ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
                sdmd.setIDependOn(n.toString());
                dependencies.add(sdmd);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException((Throwable)e);
        }
        ejbModule.setDependencies(dependencies);
        unit.addAttachment("EjbServiceMetaData", (Object)ejbModule, ServiceMetaData.class);
        AbstractKernelDeployment akd = new AbstractKernelDeployment();
        akd.setName(ejbModule.getObjectName().getCanonicalName() + "Beans");
        akd.setBeans(mcBeanMD);
        unit.addAttachment(KernelDeployment.class, (Object)akd);
        if (this.callByValue) {
            unit.addAttachment("EJB.callByValue", (Object)Boolean.TRUE, Boolean.class);
        }
        if (this.unauthenticatedIdentity != null) {
            unit.addAttachment("EJB.unauthenticatedIdentity", (Object)this.unauthenticatedIdentity, String.class);
        }
        if (this.securityContextClassName != null) {
            unit.addAttachment("EJB.securityContextClassName", (Object)this.securityContextClassName, String.class);
        }
        if (this.defaultSecurityDomain != null) {
            unit.addAttachment("EJB.defaultSecurityDomain", (Object)this.defaultSecurityDomain, String.class);
        }
    }

    public void undeploy(VFSDeploymentUnit unit, JBossMetaData deployment) {
    }

    protected ObjectName getObjectName(VFSDeploymentUnit unit, JBossMetaData metaData) throws MalformedObjectNameException {
        String name = metaData.getJmxName();
        if (name == null) {
            String unitShortName = unit.getName();
            if (unitShortName.endsWith("/")) {
                unitShortName = unitShortName.substring(0, unitShortName.length() - 1);
            }
            if (unitShortName.endsWith("!")) {
                unitShortName = unitShortName.substring(0, unitShortName.length() - 1);
            }
            unitShortName = unitShortName.substring(unitShortName.lastIndexOf("/") + 1);
            unitShortName = ObjectName.quote(unitShortName);
            name = "jboss.j2ee:service=EjbModule,module=" + unitShortName;
        }
        return new ObjectName(name);
    }

    @Override
    public boolean getStrictVerifier() {
        return this.strictVerifier;
    }

    @Override
    public boolean getVerifierVerbose() {
        return this.verifierVerbose;
    }

    @Override
    public boolean getVerifyDeployments() {
        return this.verifyDeployments;
    }

    @Override
    public void setStrictVerifier(boolean strictVerifier) {
        this.strictVerifier = strictVerifier;
    }

    @Override
    public void setVerifierVerbose(boolean verbose) {
        this.verifierVerbose = verbose;
    }

    @Override
    public void setVerifyDeployments(boolean verify) {
        this.verifyDeployments = verify;
    }
}

