/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

@Serialized
public class ExpressionValidator
implements Validator {
    private String expression_;
    private String key_;

    public ExpressionValidator() {
    }

    public ExpressionValidator(String expression) {
        this.expression_ = expression;
        this.key_ = "ExpressionValidator.msg.value-invalid";
    }

    public ExpressionValidator(String exp, String key) {
        this.expression_ = exp;
        this.key_ = key;
    }

    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        String value;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        if (uiInput.getValue() != null && (value = ((String)uiInput.getValue()).trim()).matches(this.expression_)) {
            return;
        }
        UIComponent uiComponent = (UIComponent)((Object)uiInput);
        UIForm uiForm = uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getLabel(uiInput.getName());
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        label = label.trim();
        if (label.charAt(label.length() - 1) == ':') {
            label = label.substring(0, label.length() - 1);
        }
        Object[] args = new Object[]{label};
        throw new MessageException(new ApplicationMessage(this.key_, args, 1));
    }
}

