/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.management;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.resource.deployers.management.DsDataSourceTemplateInfo;
import org.jboss.resource.deployers.management.LocalDSInstanceClassFactory;
import org.jboss.resource.deployers.management.NoTxCFInstanceClassFactory;
import org.jboss.resource.deployers.management.NoTxInstanceClassFactory;
import org.jboss.resource.deployers.management.TxInstanceClassFactory;
import org.jboss.resource.deployers.management.XADSInstanceClassFactory;
import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.TxConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class DsDataSourceTemplate
implements DeploymentTemplate {
    private static final Logger log = Logger.getLogger(DsDataSourceTemplate.class);
    private static final String FILE_SUFFIX = "-ds.xml";
    private DeploymentTemplateInfo info;

    public String getDeploymentName(String deploymentBaseName) {
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null base name.");
        }
        if (!deploymentBaseName.endsWith(FILE_SUFFIX)) {
            deploymentBaseName = deploymentBaseName + FILE_SUFFIX;
        }
        return deploymentBaseName;
    }

    public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values) throws Exception {
        return this.applyTemplate(values);
    }

    public VirtualFile applyTemplate(DeploymentTemplateInfo values) throws Exception {
        File dsXml = File.createTempFile(this.getClass().getSimpleName(), FILE_SUFFIX);
        this.writeTemplate(dsXml, values);
        return VFS.getRoot((URI)dsXml.toURI());
    }

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTemplate(File dsXml, DeploymentTemplateInfo values) throws Exception {
        ManagedObject cfMO;
        LocalDataSourceDeploymentMetaData mcf;
        ManagedProperty dsTypeMP = (ManagedProperty)values.getProperties().get("dsType");
        String cfType = null;
        if (dsTypeMP == null) {
            cfType = ((DsDataSourceTemplateInfo)values).getConnectionFactoryType();
        } else {
            SimpleValue dsTypeSV = (SimpleValue)dsTypeMP.getValue();
            cfType = dsTypeSV.getValue().toString();
        }
        ManagedObjectFactory mof = ManagedObjectFactoryBuilder.create();
        String rootElementName = "datasources";
        if ("local-tx-datasource".equals(cfType)) {
            mcf = new LocalDataSourceDeploymentMetaData();
            mof.setInstanceClassFactory(LocalDataSourceDeploymentMetaData.class, (InstanceClassFactory)new LocalDSInstanceClassFactory(mof));
            cfMO = mof.initManagedObject((Object)mcf, KnownComponentTypes.DataSourceTypes.LocalTx.getType().getType(), KnownComponentTypes.DataSourceTypes.LocalTx.getType().getSubtype());
        } else if ("xa-datasource".equals(cfType)) {
            mcf = new XADataSourceDeploymentMetaData();
            mof.setInstanceClassFactory(XADataSourceDeploymentMetaData.class, (InstanceClassFactory)new XADSInstanceClassFactory(mof));
            cfMO = mof.initManagedObject((Object)mcf, KnownComponentTypes.DataSourceTypes.XA.getType().getType(), KnownComponentTypes.DataSourceTypes.XA.getType().getSubtype());
        } else if ("tx-connection-factory".equals(cfType)) {
            rootElementName = "connection-factories";
            mcf = new TxConnectionFactoryDeploymentMetaData();
            mof.setInstanceClassFactory(TxConnectionFactoryDeploymentMetaData.class, (InstanceClassFactory)new TxInstanceClassFactory(mof));
            cfMO = mof.initManagedObject((Object)mcf, KnownComponentTypes.ConnectionFactoryTypes.XA.getType().getType(), KnownComponentTypes.ConnectionFactoryTypes.XA.getType().getSubtype());
        } else if ("no-tx-connection-factory".equals(cfType)) {
            rootElementName = "connection-factories";
            mcf = new NoTxConnectionFactoryDeploymentMetaData();
            mof.setInstanceClassFactory(NoTxConnectionFactoryDeploymentMetaData.class, (InstanceClassFactory)new NoTxCFInstanceClassFactory(mof));
            cfMO = mof.initManagedObject((Object)mcf, KnownComponentTypes.ConnectionFactoryTypes.NoTx.getType().getType(), KnownComponentTypes.ConnectionFactoryTypes.NoTx.getType().getSubtype());
        } else if ("no-tx-datasource".equals(cfType)) {
            mcf = new NoTxDataSourceDeploymentMetaData();
            mof.setInstanceClassFactory(NoTxDataSourceDeploymentMetaData.class, (InstanceClassFactory)new NoTxInstanceClassFactory(mof));
            cfMO = mof.initManagedObject((Object)mcf, KnownComponentTypes.DataSourceTypes.NoTx.getType().getType(), KnownComponentTypes.DataSourceTypes.NoTx.getType().getSubtype());
        } else {
            throw new IllegalStateException("Unexpected value connection factory type: " + cfType);
        }
        ManagedConnectionFactoryDeploymentGroup group = new ManagedConnectionFactoryDeploymentGroup();
        group.addManagedConnectionFactoryDeployment((ManagedConnectionFactoryDeploymentMetaData)mcf);
        boolean logTrace = log.isTraceEnabled();
        for (ManagedProperty tempProp : values.getProperties().values()) {
            ManagedProperty dsProp = cfMO.getProperty(tempProp.getName());
            if (dsProp != null) {
                if (logTrace) {
                    log.trace((Object)("setting " + tempProp.getName() + "=" + tempProp.getValue()));
                }
                if (tempProp.getValue() == null) continue;
                dsProp.setValue(tempProp.getValue());
                continue;
            }
            if (!logTrace) continue;
            log.trace((Object)("property not found: " + tempProp.getName()));
        }
        Class[] classes = new Class[]{ManagedConnectionFactoryDeploymentGroup.class};
        JAXBContext context = JAXBContext.newInstance((Class[])classes);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        JAXBElement root = new JAXBElement(new QName(rootElementName), ManagedConnectionFactoryDeploymentGroup.class, null, (Object)group);
        FileWriter fw = null;
        try {
            fw = new FileWriter(dsXml);
            marshaller.marshal((Object)root, (Writer)fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }
}

