/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.tx.TxInterceptor;
import org.jboss.aspects.tx.TxPolicy;
import org.jboss.logging.Logger;

public class TxInterceptor
extends org.jboss.aspects.tx.TxInterceptor {
    private static final Logger log = Logger.getLogger(TxInterceptor.class);

    public static class Mandatory
    extends TxInterceptor.Mandatory {
        public Mandatory(TransactionManager tm, TxPolicy policy) {
            this(tm, policy, -1);
        }

        public Mandatory(TransactionManager tm, TxPolicy policy, int timeout) {
            super(tm, policy, timeout);
        }

        public String getName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public Object invoke(Invocation invocation) throws Throwable {
            Transaction tx = this.tm.getTransaction();
            if (tx == null) {
                this.policy.throwMandatory(invocation);
            }
            return this.policy.invokeInCallerTx(invocation, tx);
        }
    }

    public static class NotSupported
    extends TxInterceptor.NotSupported {
        public NotSupported(TransactionManager tm, TxPolicy policy) {
            super(tm, policy);
        }

        public NotSupported(TransactionManager tm, TxPolicy policy, int timeout) {
            super(tm, policy, timeout);
        }

        public Object invoke(Invocation invocation) throws Throwable {
            Transaction tx = this.tm.getTransaction();
            if (tx != null) {
                this.tm.suspend();
                try {
                    Object object = this.policy.invokeInNoTx(invocation);
                    return object;
                }
                catch (Exception e) {
                    if (e.getClass().getAnnotation(ApplicationException.class) != null) {
                        throw e;
                    }
                    throw new EJBException(e);
                }
                finally {
                    this.tm.resume(tx);
                }
            }
            return this.policy.invokeInNoTx(invocation);
        }
    }

    public static class Never
    extends TxInterceptor.Never {
        public Never(TransactionManager tm, TxPolicy policy) {
            super(tm, policy);
        }

        public Object invoke(Invocation invocation) throws Throwable {
            if (this.tm.getTransaction() != null) {
                throw new EJBException("Transaction present on server in Never call (EJB3 13.6.2.6)");
            }
            return this.policy.invokeInNoTx(invocation);
        }
    }
}

