/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.context.ScopeType;
import javax.event.Observes;
import javax.inject.DefinitionException;
import javax.inject.DeploymentType;
import javax.inject.Disposes;
import javax.inject.Initializer;
import javax.inject.Produces;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.AnnotatedInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisposalMethodBean<T>
extends AbstractBean<T, Method> {
    private static final LogProvider log = Logging.getLogProvider(AbstractProducerBean.class);
    protected AbstractClassBean<?> declaringBean;
    private DisposalMethodBean<?> specializedBean;
    protected MethodInjectionPoint<T> disposalMethodInjectionPoint;
    protected Set<AnnotatedInjectionPoint<?, ?>> disposalInjectionPoints;
    private String id;

    protected DisposalMethodBean(ManagerImpl manager, AnnotatedMethod<T> disposalMethod, AbstractClassBean<?> declaringBean) {
        super(manager);
        this.disposalMethodInjectionPoint = MethodInjectionPoint.of(this, disposalMethod);
        this.declaringBean = declaringBean;
        this.checkDisposalMethod();
        this.initInjectionPoints();
        this.initType();
        this.initTypes();
        this.id = DisposalMethodBean.createId("DisposalMethod-" + declaringBean.getName() + "-" + disposalMethod.getSignature().toString());
    }

    protected void initType() {
        this.type = this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).get(0).getRawType();
    }

    public AnnotatedMethod<T> getAnnotatedItem() {
        return this.disposalMethodInjectionPoint;
    }

    public static <T> DisposalMethodBean<T> of(ManagerImpl manager, AnnotatedMethod<T> disposalMethod, AbstractClassBean<?> declaringBean) {
        return new DisposalMethodBean<T>(manager, disposalMethod, declaringBean);
    }

    private void initInjectionPoints() {
        this.disposalInjectionPoints = new HashSet();
        List<ParameterInjectionPoint<?>> disposalMethodParameters = this.disposalMethodInjectionPoint.getParameters();
        if (disposalMethodParameters.size() > 1) {
            for (int i = 1; i < disposalMethodParameters.size(); ++i) {
                AnnotatedParameter parameter = disposalMethodParameters.get(i);
                this.disposalInjectionPoints.add(ParameterInjectionPoint.of(this.declaringBean, parameter));
            }
        }
        this.injectionPoints.add(MethodInjectionPoint.of(this.declaringBean, this.disposalMethodInjectionPoint));
    }

    @Override
    public Set<Annotation> getBindings() {
        return this.disposalMethodInjectionPoint.getParameters().get(0).getBindings();
    }

    @Override
    public Class<? extends Annotation> getDeploymentType() {
        return this.declaringBean.getDeploymentType();
    }

    @Override
    protected void initTypes() {
        HashSet<? extends Type> types = new HashSet<Type>();
        types = new HashSet();
        types.addAll(this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).get(0).getFlattenedTypeHierarchy());
        types.add(this.getType());
        types.add((Type)((Object)Object.class));
        this.types = types;
    }

    @Override
    public Set<AnnotatedInjectionPoint<?, ?>> getInjectionPoints() {
        return this.injectionPoints;
    }

    @Override
    public String getName() {
        return this.disposalMethodInjectionPoint.getPropertyName();
    }

    @Override
    public Class<? extends Annotation> getScopeType() {
        return this.declaringBean.getScopeType();
    }

    @Override
    public Set<? extends Type> getTypes() {
        return this.types;
    }

    @Override
    public String toString() {
        return this.disposalMethodInjectionPoint.toString();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSerializable() {
        return this.declaringBean.isSerializable();
    }

    public T create(CreationalContext<T> creationalContext) {
        return null;
    }

    public void invokeDisposeMethod(Object instance) {
        LinkedList<Object> parameters = new LinkedList<Object>();
        parameters.add(instance);
        for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.disposalInjectionPoints) {
            Object injectionObject = this.getManager().getInstanceToInject(injectionPoint);
            parameters.add(injectionObject);
        }
        AbstractClassBean<?> beanInstance = this.disposalMethodInjectionPoint.isStatic() ? this.declaringBean : this.getManager().getInstance(this.declaringBean);
        this.disposalMethodInjectionPoint.invokeWithSpecialValue(beanInstance, (Class<Annotation>)Disposes.class, instance, this.manager, (CreationalContext<?>)null, (Class<RuntimeException>)IllegalArgumentException.class);
    }

    private void checkDisposalMethod() {
        if (!this.disposalMethodInjectionPoint.getParameters().get(0).isAnnotationPresent(Disposes.class)) {
            throw new DefinitionException(this.disposalMethodInjectionPoint.toString() + " doesn't have @Dispose as first parameter");
        }
        if (this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).size() > 1) {
            throw new DefinitionException(this.disposalMethodInjectionPoint.toString() + " has more than one @Dispose parameters");
        }
        if (this.disposalMethodInjectionPoint.getAnnotatedParameters(Observes.class).size() > 0) {
            throw new DefinitionException("@Observes is not allowed on disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.disposalMethodInjectionPoint.getAnnotation(Initializer.class) != null) {
            throw new DefinitionException("@Intitializer is not allowed on a disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.disposalMethodInjectionPoint.getAnnotation(Produces.class) != null) {
            throw new DefinitionException("@Produces is not allowed on a disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.declaringBean instanceof EnterpriseBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.declaringBean.getTypes()) {
                if (!(type instanceof Class)) continue;
                Class clazz = (Class)type;
                try {
                    clazz.getDeclaredMethod(this.disposalMethodInjectionPoint.getName(), this.disposalMethodInjectionPoint.getParameterTypesAsArray());
                    methodDeclaredOnTypes = true;
                }
                catch (NoSuchMethodException nsme) {}
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException("Producer method " + this.toString() + " must be declared on a business interface of " + this.declaringBean);
            }
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        if (this.declaringBean.getAnnotatedItem().getSuperclass().getDeclaredMethod(this.getAnnotatedItem().getAnnotatedMethod()) == null) {
            throw new DefinitionException("Specialized disposal method does not override a method on the direct superclass");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        AnnotatedMethod<?> superClassMethod = this.declaringBean.getAnnotatedItem().getSuperclass().getMethod(this.getAnnotatedItem().getAnnotatedMethod());
        if (environment.getProducerMethod(superClassMethod) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        this.specializedBean = environment.getDisposalMethod(superClassMethod);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        return this.declaringBean.getDeploymentType();
    }

    @Override
    protected String getDefaultName() {
        return this.disposalMethodInjectionPoint.getPropertyName();
    }

    @Override
    protected void initDeploymentType() {
        Set<Annotation> deploymentTypes = this.getAnnotatedItem().getMetaAnnotations(DeploymentType.class);
        if (deploymentTypes.size() > 1) {
            throw new DefinitionException("At most one deployment type may be specified (" + deploymentTypes + " are specified) on " + this.getAnnotatedItem().toString());
        }
        if (deploymentTypes.size() == 1) {
            this.deploymentType = deploymentTypes.iterator().next().annotationType();
            log.trace((Object)("Deployment type " + this.deploymentType + " specified by annotation"));
            return;
        }
        this.initDeploymentTypeFromStereotype();
        if (this.deploymentType == null) {
            this.deploymentType = this.getDefaultDeploymentType();
            log.trace((Object)("Using default " + this.deploymentType + " deployment type"));
            return;
        }
    }

    @Override
    protected void initScopeType() {
        Set<Annotation> scopeAnnotations = this.getAnnotatedItem().getMetaAnnotations(ScopeType.class);
        if (scopeAnnotations.size() > 1) {
            throw new DefinitionException("At most one scope may be specified");
        }
        if (scopeAnnotations.size() == 1) {
            this.scopeType = scopeAnnotations.iterator().next().annotationType();
            log.trace((Object)("Scope " + this.scopeType + " specified by annotation"));
            return;
        }
        this.initScopeTypeFromStereotype();
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace((Object)"Using default @Dependent scope");
        }
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    public void destroy(T instance) {
    }

    @Override
    public String getId() {
        return this.id;
    }
}

