/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.lang.annotation.Annotation;
import java.util.concurrent.locks.ReentrantLock;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.CreationalContext;
import org.jboss.webbeans.context.AbstractContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapContext
extends AbstractContext {
    private static LogProvider log = Logging.getLogProvider(AbstractMapContext.class);
    private static ReentrantLock creationLock = new ReentrantLock();

    public AbstractMapContext(Class<? extends Annotation> scopeType) {
        super(scopeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        Object instance = this.getBeanStore().get(contextual);
        if (instance != null) {
            return (T)instance;
        }
        if (creationalContext != null) {
            boolean needCreationLock = this.isCreationLockRequired();
            try {
                if (needCreationLock) {
                    creationLock.lock();
                    instance = this.getBeanStore().get(contextual);
                    if (instance != null) {
                        Object object = instance;
                        return (T)object;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    this.getBeanStore().put(contextual, instance);
                }
                Object object = instance;
                return (T)object;
            }
            finally {
                if (needCreationLock) {
                    creationLock.unlock();
                }
            }
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    private <T> void destroy(Contextual<T> bean) {
        log.trace((Object)("Destroying " + bean));
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        bean.destroy(this.getBeanStore().get(bean));
    }

    public void destroy() {
        log.trace((Object)"Destroying context");
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        for (Contextual bean : this.getBeanStore().getBeans()) {
            this.destroy(bean);
        }
        this.getBeanStore().clear();
    }

    protected abstract BeanStore getBeanStore();

    protected abstract boolean isCreationLockRequired();
}

