/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class RouterStub {
    public static final int STATUS_CONNECTED = 0;
    public static final int STATUS_DISCONNECTED = 1;
    private String router_host = null;
    private int router_port = 0;
    private Socket sock = null;
    private DataOutputStream output = null;
    private DataInputStream input = null;
    private Address local_addr = null;
    private volatile int connectionState = 1;
    private static final Log log = LogFactory.getLog(RouterStub.class);
    private ConnectionListener conn_listener;
    private String groupname = null;
    private InetAddress bind_addr = null;
    private DatagramSocket my_sock = null;

    public RouterStub(String routerHost, int routerPort, InetAddress bindAddress) {
        this.router_host = routerHost != null ? routerHost : "localhost";
        this.router_port = routerPort;
        this.bind_addr = bindAddress;
    }

    public boolean isConnected() {
        return this.connectionState == 0;
    }

    public void setConnectionListener(ConnectionListener conn_listener) {
        this.conn_listener = conn_listener;
    }

    public synchronized Address getLocalAddress() throws SocketException {
        if (this.local_addr == null) {
            this.my_sock = new DatagramSocket(0, this.bind_addr);
            this.local_addr = new IpAddress(this.bind_addr, this.my_sock.getLocalPort());
        }
        return this.local_addr;
    }

    public synchronized void connect(String groupname) throws Exception {
        if (groupname == null || groupname.length() == 0) {
            throw new Exception("groupname is null");
        }
        if (!this.isConnected()) {
            this.groupname = groupname;
            try {
                this.sock = new Socket(this.router_host, this.router_port, this.bind_addr, 0);
                this.sock.setSoLinger(true, 5);
                this.output = new DataOutputStream(this.sock.getOutputStream());
                GossipData req = new GossipData(1, groupname, this.getLocalAddress(), null);
                req.writeTo(this.output);
                this.output.flush();
                this.input = new DataInputStream(this.sock.getInputStream());
                boolean connectedOk = this.input.readBoolean();
                if (!connectedOk) {
                    throw new Exception("Failed to get connection ack from gossip router");
                }
                this.connectionStateChanged(0);
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)(this + " failed connecting to " + this.router_host + ":" + this.router_port));
                }
                Util.close(this.sock);
                Util.close(this.input);
                Util.close(this.output);
                this.connectionStateChanged(1);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void disconnect() {
        try {
            try {
                GossipData req = new GossipData(2, this.groupname, this.local_addr, null);
                req.writeTo(this.output);
                this.output.flush();
            }
            catch (Exception exception) {
                Object var3_4 = null;
                Util.close(this.output);
                Util.close(this.input);
                Util.close(this.sock);
                Util.close(this.my_sock);
                this.sock = null;
                this.connectionStateChanged(1);
                return;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Util.close(this.output);
            Util.close(this.input);
            Util.close(this.sock);
            Util.close(this.my_sock);
            this.sock = null;
            this.connectionStateChanged(1);
            throw throwable;
        }
        Util.close(this.output);
        Util.close(this.input);
        Util.close(this.sock);
        Util.close(this.my_sock);
        this.sock = null;
        this.connectionStateChanged(1);
    }

    public String toString() {
        return "RouterStub[local_address=" + this.local_addr + ",router_host=" + this.router_host + ",router_port=" + this.router_port + ",connected=" + this.isConnected() + "]";
    }

    public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
        this.sendToSingleMember(null, data, offset, length);
    }

    public synchronized void sendToSingleMember(Address dest, byte[] data, int offset, int length) throws Exception {
        if (this.isConnected()) {
            try {
                this.output.writeUTF(this.groupname);
                Util.writeAddress(dest, this.output);
                this.output.writeInt(data.length);
                this.output.write(data, 0, data.length);
                this.output.flush();
            }
            catch (SocketException se) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Router stub " + this + " did not send message to " + (dest == null ? "mcast" : dest + " since underlying socket is closed")));
                }
                this.connectionStateChanged(1);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Router stub " + this + " failed sending message to router"));
                }
                this.connectionStateChanged(1);
                throw new Exception("dest=" + dest + " (" + length + " bytes)", e);
            }
        }
    }

    public DataInputStream getInputStream() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("InputStream is closed");
        }
        return this.input;
    }

    private void connectionStateChanged(int newState) {
        boolean notify = this.connectionState != newState;
        this.connectionState = newState;
        if (notify && this.conn_listener != null) {
            try {
                this.conn_listener.connectionStatusChange(newState);
            }
            catch (Throwable t) {
                log.error((Object)("failed notifying ConnectionListener " + this.conn_listener), t);
            }
        }
    }

    public static interface ConnectionListener {
        public void connectionStatusChange(int var1);
    }
}

