/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.jmx;

import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.cache.pojo.jmx.PojoCacheJmxWrapperMBean;

public class JmxUtil
extends org.jboss.cache.jmx.JmxUtil {
    public static final String POJO_CACHE_DOMAIN = "jboss.pojocache";
    public static final String POJO_CACHE_TYPE = "PojoCache";

    public static void registerPojoCache(MBeanServer server, PojoCacheJmxWrapperMBean cache, String objectName) throws Exception {
        if (server == null || cache == null || objectName == null) {
            return;
        }
        ObjectName tmpObj = new ObjectName(objectName);
        if (!server.isRegistered(tmpObj)) {
            server.registerMBean(cache, tmpObj);
        }
    }

    public static ObjectName getPlainCacheObjectName(ObjectName pojoCacheName) throws MalformedObjectNameException {
        String domain = pojoCacheName.getDomain();
        Hashtable<String, String> attributes = new Hashtable<String, String>(pojoCacheName.getKeyPropertyList());
        String type = attributes.get("cacheType");
        if (type == null || POJO_CACHE_TYPE.equals(type)) {
            attributes.put("cacheType", "Cache");
        } else {
            attributes.put("uniqueId", String.valueOf(System.currentTimeMillis()));
        }
        return new ObjectName(domain, attributes);
    }

    public static void unregisterPojoCache(MBeanServer server, String objectName) throws Exception {
        if (server == null || objectName == null) {
            return;
        }
        ObjectName on = new ObjectName(objectName);
        if (server.isRegistered(on)) {
            server.unregisterMBean(on);
        }
    }
}

