/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;

public class SessionSynchronizationInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(SessionSynchronizationInterceptor.class);
    private TransactionManager tm = TxUtil.getTransactionManager();

    public String getName() {
        return null;
    }

    protected void registerSessionSynchronization(StatefulBeanContext ctx) throws RemoteException, SystemException {
        if (ctx.isTxSynchronized()) {
            return;
        }
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            return;
        }
        if (tx.getStatus() == 1) {
            return;
        }
        SFSBSessionSynchronization synch = new SFSBSessionSynchronization(ctx);
        try {
            tx.registerSynchronization((Synchronization)synch);
        }
        catch (RollbackException e) {
            log.warn((Object)("Unexpected RollbackException from tx " + tx + " with status " + tx.getStatus()));
            throw new EJBException((Exception)((Object)e));
        }
        ctx.setTxSynchronized(true);
        SessionSynchronization bean = (SessionSynchronization)ctx.getInstance();
        bean.afterBegin();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        StatefulBeanContext target = (StatefulBeanContext)ejb.getBeanContext();
        if (target.getInstance() instanceof SessionSynchronization) {
            this.registerSessionSynchronization(target);
        }
        return ejb.invokeNext();
    }

    protected static class SFSBSessionSynchronization
    implements Synchronization {
        private StatefulBeanContext ctx;

        public SFSBSessionSynchronization(StatefulBeanContext ctx) {
            this.ctx = ctx;
        }

        public void beforeCompletion() {
            SessionSynchronization bean = (SessionSynchronization)this.ctx.getInstance();
            if (bean == null) {
                return;
            }
            this.pushEnc();
            try {
                try {
                    AllowedOperationsAssociation.pushInMethodFlag((int)AllowedOperationsAssociation.IN_BEFORE_COMPLETION);
                    bean.beforeCompletion();
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                this.popEnc();
                throw throwable;
            }
            AllowedOperationsAssociation.popInMethodFlag();
            this.popEnc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterCompletion(int status) {
            StatefulContainer container2222;
            this.ctx.setTxSynchronized(false);
            SessionSynchronization bean = (SessionSynchronization)this.ctx.getInstance();
            if (bean == null) {
                return;
            }
            this.pushEnc();
            try {
                try {
                    if (status == 3) {
                        bean.afterCompletion(true);
                    }
                    bean.afterCompletion(false);
                }
                catch (RemoteException remoteException) {
                    Object var5_4 = null;
                    this.popEnc();
                    StatefulContainer container2222 = this.ctx.getContainer();
                    container2222.getCache().release(this.ctx);
                    return;
                }
                Object var5_3 = null;
                this.popEnc();
                container2222 = this.ctx.getContainer();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.popEnc();
                StatefulContainer container2222 = this.ctx.getContainer();
                container2222.getCache().release(this.ctx);
                throw throwable;
            }
            container2222.getCache().release(this.ctx);
        }

        private void popEnc() {
            StatefulContainer container = this.ctx.getContainer();
            BeanContext<?> old = container.popContext();
            assert (old == this.ctx);
            container.popEnc();
        }

        private void pushEnc() {
            StatefulContainer container = this.ctx.getContainer();
            container.pushEnc();
            container.pushContext(this.ctx);
        }
    }
}

