/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.server.content;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.rhq.core.domain.content.ContentRequestStatus;

public class ContentServiceResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int requestId;
    private ContentRequestStatus status;
    private String errorMessage;

    public ContentServiceResponse(int requestId) {
        this.requestId = requestId;
        this.status = ContentRequestStatus.SUCCESS;
    }

    public ContentServiceResponse(int requestId, String errorMessage) {
        this.requestId = requestId;
        this.status = ContentRequestStatus.FAILURE;
        this.errorMessage = errorMessage;
    }

    public ContentServiceResponse(int requestId, Throwable error) {
        this.requestId = requestId;
        this.status = ContentRequestStatus.FAILURE;
        this.setErrorMessageFromThrowable(error);
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    public ContentRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(ContentRequestStatus status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }
}

