/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.transport.axis;

import java.util.Vector;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.Admin;
import org.apache.juddi.datatype.request.Inquiry;
import org.apache.juddi.datatype.request.Publish;
import org.apache.juddi.datatype.request.SecurityPolicy;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.BusyException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.registry.RegistryServlet;
import org.apache.juddi.transport.axis.AdminServlet;
import org.apache.juddi.transport.axis.InquiryServlet;
import org.apache.juddi.transport.axis.PublishServlet;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisProcessor {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$transport$axis$AxisProcessor == null ? (class$org$apache$juddi$transport$axis$AxisProcessor = AxisProcessor.class$("org.apache.juddi.transport.axis.AxisProcessor")) : class$org$apache$juddi$transport$axis$AxisProcessor));
    private static HandlerMaker maker = HandlerMaker.getInstance();
    static /* synthetic */ Class class$org$apache$juddi$transport$axis$AxisProcessor;

    public AxisProcessor(Message soapResponse, MessageContext messageContext) {
        SOAPEnvelope soapReqEnv = null;
        SOAPEnvelope soapResEnv = null;
        Message soapRequest = messageContext.getRequestMessage();
        try {
            log.debug((Object)soapRequest.getSOAPPartAsString());
        }
        catch (AxisFault af) {
            af.printStackTrace();
        }
        Element request = null;
        Element response = null;
        String function = null;
        String generic = null;
        try {
            AbstractHandler requestHandler;
            soapReqEnv = soapRequest.getSOAPEnvelope();
            soapResEnv = soapResponse.getSOAPEnvelope();
            SOAPBodyElement requestBody = soapReqEnv.getFirstBody();
            request = requestBody.getAsDOM();
            function = request.getLocalName();
            generic = request.getAttribute("generic");
            if (generic == null) {
                generic = "2.0";
            }
            if ((requestHandler = maker.lookup(function)) == null) {
                throw new UnsupportedException("The request type is unknown: " + function);
            }
            RegistryObject uddiRequest = requestHandler.unmarshal(request);
            Object juddiServlet = messageContext.getProperty("transport.http.servlet");
            if (juddiServlet instanceof InquiryServlet && !(uddiRequest instanceof Inquiry)) {
                throw new RegistryException("Inquiry API does not support function: " + function);
            }
            if (juddiServlet instanceof PublishServlet && !(uddiRequest instanceof Publish) && !(uddiRequest instanceof SecurityPolicy)) {
                throw new RegistryException("Publish API does not support function: " + function);
            }
            if (juddiServlet instanceof AdminServlet && !(uddiRequest instanceof Admin)) {
                throw new RegistryException("Admin API does not support function: " + function);
            }
            RegistryObject uddiResponse = null;
            RegistryEngine registry = RegistryServlet.getRegistry();
            if (registry == null || !registry.isAvailable()) {
                throw new BusyException("The Registry is unavailable");
            }
            uddiResponse = registry.execute(uddiRequest);
            Document document = XMLUtils.createDocument();
            Element element = document.createElement("temp");
            AbstractHandler responseHandler = maker.lookup(uddiResponse.getClass().getName());
            responseHandler.marshal(uddiResponse, element);
            response = (Element)element.getFirstChild();
            SOAPBodyElement soapRespBody = new SOAPBodyElement(response);
            SOAPEnvelope soapRespEnv = soapResponse.getSOAPEnvelope();
            soapRespEnv.addBodyElement(soapRespBody);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            String faultCode = null;
            String faultString = null;
            String faultActor = null;
            String errno = null;
            String errCode = null;
            String errText = null;
            if (ex instanceof RegistryException) {
                RegistryException rex = (RegistryException)ex;
                faultCode = rex.getFaultCode();
                faultString = rex.getFaultString();
                faultActor = rex.getFaultActor();
                DispositionReport dispRpt = rex.getDispositionReport();
                if (dispRpt != null) {
                    Result result = null;
                    ErrInfo errInfo = null;
                    Vector results = dispRpt.getResultVector();
                    if (results != null && !results.isEmpty()) {
                        result = (Result)results.elementAt(0);
                    }
                    if (result != null) {
                        errno = String.valueOf(result.getErrno());
                        errInfo = result.getErrInfo();
                        if (errInfo != null) {
                            errCode = errInfo.getErrCode();
                            errText = errInfo.getErrMsg();
                        }
                    }
                }
            } else {
                faultCode = "Server";
                faultString = ex.getMessage();
                faultActor = null;
                errno = String.valueOf(10500);
                errCode = Result.lookupErrCode(10500);
                errText = Result.lookupErrText(10500) + " An internal UDDI server error has " + "occurred. Please report this error " + "to the UDDI server administrator.";
            }
            try {
                SOAPBody soapResBody = soapResEnv.getBody();
                SOAPFault soapFault = soapResBody.addFault();
                soapFault.setFaultCode(faultCode);
                soapFault.setFaultString(faultString);
                soapFault.setFaultActor(faultActor);
                Detail faultDetail = soapFault.addDetail();
                SOAPElement dispRpt = faultDetail.addChildElement("dispositionReport", "", "urn:uddi-org:api_v2");
                dispRpt.setAttribute("generic", "2.0");
                dispRpt.setAttribute("operator", Config.getOperator());
                SOAPElement result = dispRpt.addChildElement("result");
                result.setAttribute("errno", errno);
                SOAPElement errInfo = result.addChildElement("errInfo");
                errInfo.setAttribute("errCode", errCode);
                errInfo.setValue(errText);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            log.debug((Object)soapResponse.getSOAPPartAsString());
        }
        catch (AxisFault af) {
            af.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

