/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.spi.dependency.DependencyBuilderListItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;

class AspectDependencyBuilderListItem
implements DependencyBuilderListItem {
    protected static Logger log = Logger.getLogger(AspectDependencyBuilderListItem.class);
    protected String dependencyName;

    AspectDependencyBuilderListItem(String name) {
        this.dependencyName = name;
    }

    public void addDependency(KernelControllerContext context) {
        BeanMetaData metaData = context.getBeanMetaData();
        AbstractDependencyItem dependencyItem = new AbstractDependencyItem((Object)metaData.getName(), (Object)this.dependencyName, ControllerState.INSTANTIATED, ControllerState.INSTALLED);
        DependencyInfo depends = context.getDependencyInfo();
        depends.addIDependOn((DependencyItem)dependencyItem);
    }

    public void removeDependency(KernelControllerContext context) {
        DependencyInfo depends = context.getDependencyInfo();
        Set items = depends.getIDependOn(null);
        if (items.size() > 0) {
            for (DependencyItem item : items) {
                try {
                    Object iDependOn = item.getIDependOn();
                    if (iDependOn == null || !iDependOn.equals(this.dependencyName)) continue;
                    depends.removeIDependOn(item);
                }
                catch (RuntimeException e) {
                    log.warn((Object)("Problem uninstalling dependency " + this.dependencyName + " for " + context), (Throwable)e);
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof AspectDependencyBuilderListItem) {
            return this.dependencyName.equals(((AspectDependencyBuilderListItem)o).dependencyName);
        }
        return false;
    }

    public int hashCode() {
        return this.dependencyName.hashCode();
    }
}

