/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.eviction.ElementSizeAlgorithm;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;

public class ElementSizeAlgorithmConfig
extends EvictionAlgorithmConfigBase {
    private static final long serialVersionUID = 2510593544656833758L;
    @Dynamic
    private int maxElementsPerNode = -1;

    public ElementSizeAlgorithmConfig() {
        this.evictionAlgorithmClassName = ElementSizeAlgorithm.class.getName();
        this.setMaxElementsPerNode(-1);
    }

    public ElementSizeAlgorithmConfig(int maxNodes, int maxElementsPerNode) {
        this();
        this.setMaxNodes(maxNodes);
        this.setMaxElementsPerNode(maxElementsPerNode);
    }

    public int getMaxElementsPerNode() {
        return this.maxElementsPerNode;
    }

    public void setMaxElementsPerNode(int maxElementsPerNode) {
        this.testImmutability("maxElementsPerNode");
        this.maxElementsPerNode = maxElementsPerNode;
    }

    public void validate() throws ConfigurationException {
        super.validate();
        if (this.maxElementsPerNode < -1) {
            this.maxElementsPerNode = -1;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ElementSizeConfiguration: maxElementsPerNode =");
        str.append(this.getMaxElementsPerNode()).append(" maxNodes =").append(this.getMaxNodes());
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ElementSizeAlgorithmConfig && super.equals(obj)) {
            return this.maxElementsPerNode == ((ElementSizeAlgorithmConfig)obj).maxElementsPerNode;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxElementsPerNode;
        return result;
    }

    public void reset() {
        super.reset();
        this.setMaxElementsPerNode(-1);
        this.evictionAlgorithmClassName = ElementSizeAlgorithm.class.getName();
    }

    public ElementSizeAlgorithmConfig clone() throws CloneNotSupportedException {
        return (ElementSizeAlgorithmConfig)super.clone();
    }
}

